/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store;

import com.qwazr.database.store.KeyIterator;
import com.qwazr.database.store.KeyStore;
import com.qwazr.utils.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.fusesource.lmdbjni.Database;
import org.fusesource.lmdbjni.EntryIterator;
import org.fusesource.lmdbjni.Env;
import org.fusesource.lmdbjni.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyStoreLmdb
implements KeyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreLmdb.class);
    private final Env env;
    private final Database db;
    private final File file;

    public KeyStoreLmdb(File file) throws IOException {
        this.file = file;
        if (!file.exists()) {
            file.mkdir();
        }
        this.env = new Env(file.getAbsolutePath());
        this.db = this.env.openDatabase();
    }

    @Override
    public final void close() throws IOException {
        IOUtils.close(this.db, this.env);
    }

    @Override
    public final boolean exists() {
        return this.file.exists();
    }

    @Override
    public final void delete() throws IOException {
        this.env.close();
    }

    @Override
    public final byte[] get(byte[] key) {
        return this.db.get(key);
    }

    @Override
    public final void put(byte[] key, byte[] value) {
        this.db.put(key, value);
    }

    @Override
    public final void delete(byte[] key) throws IOException {
        this.db.delete(key);
    }

    @Override
    public final KeyIterator iterator(byte[] key) {
        return new KeyIteratorImpl(key);
    }

    private class KeyIteratorImpl
    implements KeyIterator {
        private final Transaction tx;
        private final EntryIterator it;

        private KeyIteratorImpl(byte[] key) {
            this.tx = KeyStoreLmdb.this.env.createReadTransaction();
            this.it = KeyStoreLmdb.this.db.seek(this.tx, key);
        }

        @Override
        public final void close() throws IOException {
            IOUtils.close(this.it, this.tx);
        }

        @Override
        public final boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public final Map.Entry<byte[], byte[]> next() {
            return this.it.next();
        }
    }
}

