/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store;

import com.fasterxml.jackson.databind.JsonNode;
import com.qwazr.database.store.QueryContext;
import com.qwazr.utils.concurrent.ThreadUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.roaringbitmap.RoaringBitmap;

public abstract class Query {
    public static final Query prepare(JsonNode node, QueryHook queryHook) throws QueryException {
        Query newQuery;
        if (!node.isObject()) {
            throw new QueryException("Query error: An object was expected. But got " + (Object)((Object)node.getNodeType()) + " Near: " + node.asText());
        }
        if (node.size() == 0) {
            throw new QueryException("The query is empty: Near: " + node.asText());
        }
        if (node.size() > 1) {
            throw new QueryException("Query error: More than one object has been found. Near: " + node.asText());
        }
        if (node.has("$OR")) {
            newQuery = new OrGroup(node.get("$OR"), queryHook);
        } else if (node.has("$AND")) {
            newQuery = new AndGroup(node.get("$AND"), queryHook);
        } else {
            Map.Entry<String, JsonNode> entry = node.fields().next();
            String field = entry.getKey();
            JsonNode valueNode = entry.getValue();
            if (valueNode.isTextual()) {
                newQuery = new TermQuery<String>(field, valueNode.asText());
            } else if (valueNode.isNumber()) {
                newQuery = valueNode.isInt() ? new TermQuery<Integer>(field, valueNode.asInt()) : (node.isLong() ? new TermQuery<Long>(field, valueNode.asLong()) : new TermQuery<Double>(field, valueNode.asDouble()));
            } else {
                throw new QueryException("Unexpected value: " + field + "  Type: " + (Object)((Object)valueNode.getNodeType()));
            }
        }
        if (queryHook != null) {
            queryHook.query(newQuery);
        }
        return newQuery;
    }

    abstract RoaringBitmap execute(QueryContext var1, ExecutorService var2) throws IOException;

    public static interface QueryHook {
        public void query(Query var1);
    }

    public static class QueryException
    extends RuntimeException {
        private static final long serialVersionUID = -5566235355622756480L;

        private QueryException(String reason) {
            super(reason);
        }
    }

    public static class AndGroup
    extends GroupQuery {
        protected AndGroup(JsonNode node, QueryHook queryHook) {
            super(node, queryHook);
        }

        public AndGroup() {
        }

        @Override
        final RoaringBitmap execute(QueryContext context, ExecutorService executor) throws IOException {
            try {
                RoaringBitmap finalBitmap = new RoaringBitmap();
                AtomicBoolean first = new AtomicBoolean(true);
                ThreadUtils.parallel(this.queries, query -> {
                    RoaringBitmap bitmap = query.execute(context, executor);
                    if (bitmap == null) {
                        return;
                    }
                    RoaringBitmap roaringBitmap = finalBitmap;
                    synchronized (roaringBitmap) {
                        if (first.getAndSet(false)) {
                            finalBitmap.or(bitmap);
                        } else {
                            finalBitmap.and(bitmap);
                        }
                    }
                });
                return finalBitmap;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public static class OrGroup
    extends GroupQuery {
        protected OrGroup(JsonNode node, QueryHook queryHook) {
            super(node, queryHook);
        }

        public OrGroup() {
        }

        @Override
        final RoaringBitmap execute(QueryContext context, ExecutorService executor) throws IOException {
            try {
                RoaringBitmap finalBitmap = new RoaringBitmap();
                ThreadUtils.parallel(this.queries, query -> {
                    RoaringBitmap bitmap = query.execute(context, executor);
                    if (bitmap == null) {
                        return;
                    }
                    RoaringBitmap roaringBitmap = finalBitmap;
                    synchronized (roaringBitmap) {
                        finalBitmap.or(bitmap);
                    }
                });
                return finalBitmap;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }

    static abstract class GroupQuery
    extends Query {
        protected final List<Query> queries;

        protected GroupQuery(JsonNode node, QueryHook queryHook) throws QueryException {
            if (!node.isArray()) {
                throw new QueryException("Array expected, but got " + (Object)((Object)node.getNodeType()));
            }
            this.queries = new ArrayList<Query>(node.size());
            node.forEach(n -> this.queries.add(Query.prepare(n, queryHook)));
        }

        protected GroupQuery() {
            this.queries = new ArrayList<Query>();
        }

        public final void add(Query query) {
            this.queries.add(query);
        }
    }

    public static class TermQuery<T>
    extends Query {
        private String field;
        private final T value;

        public TermQuery(String field, T value) {
            this.field = field;
            this.value = value;
        }

        @Override
        final RoaringBitmap execute(QueryContext context, ExecutorService executor) throws IOException {
            RoaringBitmap bitset = context.getIndexedBitset(this.field, this.value);
            if (bitset == null) {
                bitset = new RoaringBitmap();
            }
            return bitset;
        }

        public final void setField(String field) {
            this.field = field;
        }

        public final String getField() {
            return this.field;
        }

        public final T getValue() {
            return this.value;
        }
    }
}

