/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store;

import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.store.CollectorInterface;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.ValueConsumer;
import com.qwazr.database.store.keys.ColumnIndexKey;
import com.qwazr.database.store.keys.ColumnStoreKey;
import com.qwazr.database.store.keys.PrimaryIdsKey;
import com.qwazr.server.ServerException;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.roaringbitmap.RoaringBitmap;

public class QueryContext {
    final KeyStore store;
    final Map<String, ColumnDefinition.Internal> columns;

    QueryContext(KeyStore store, Map<String, ColumnDefinition.Internal> columns) {
        this.store = store;
        this.columns = columns;
    }

    public final RoaringBitmap getIndexedBitset(String columnName, Object value) throws IOException {
        ColumnDefinition.Internal colDef = this.columns.get(columnName);
        if (colDef == null) {
            throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Unknown column: " + columnName);
        }
        if (colDef.mode != ColumnDefinition.Mode.INDEXED) {
            throw new ServerException(Response.Status.NOT_ACCEPTABLE, "The column is not indexed: " + columnName);
        }
        return (RoaringBitmap)ColumnIndexKey.newInstance(colDef, value).getValue(this.store);
    }

    public final CollectorInterface newFacetCollector(CollectorInterface collector, String columnName, Map<Object, CollectorInterface.LongCounter> facetMap) {
        return collector.facets(this, this.columns.get(columnName), facetMap);
    }

    public Integer getExistingDocId(String key) throws IOException {
        return (Integer)new PrimaryIdsKey(key).getValue(this.store);
    }

    public void consumeFirstValue(String columnName, int docId, ValueConsumer consumer) throws IOException {
        ColumnStoreKey.newInstance(this.columns.get(columnName), docId).forFirst(this.store, consumer);
    }
}

