/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store;

import com.fasterxml.jackson.core.type.TypeReference;
import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.store.ByteConverter;
import com.qwazr.database.store.CollectorInterface;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.Query;
import com.qwazr.database.store.QueryContext;
import com.qwazr.database.store.QueryResult;
import com.qwazr.database.store.Tables;
import com.qwazr.database.store.keys.ColumnDefKey;
import com.qwazr.database.store.keys.ColumnDefsKey;
import com.qwazr.database.store.keys.ColumnIndexKey;
import com.qwazr.database.store.keys.ColumnIndexesKey;
import com.qwazr.database.store.keys.ColumnStoreKey;
import com.qwazr.database.store.keys.ColumnStoresKey;
import com.qwazr.database.store.keys.PrimaryIdsKey;
import com.qwazr.database.store.keys.PrimaryIndexKey;
import com.qwazr.server.ServerException;
import com.qwazr.utils.LockUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.Response;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Table.class);
    private final LockUtils.ReadWriteLock rwlColumns = new LockUtils.ReadWriteLock();
    final File directory;
    final KeyStore keyStore;
    final ColumnDefsKey columnDefsKey;
    final PrimaryIndexKey primaryIndexKey;
    private static final ExecutorService readExecutor = Executors.newFixedThreadPool(12);
    private static final ExecutorService writeExecutor = Executors.newFixedThreadPool(4);
    public static final TypeReference<Map<String, Integer>> MapStringIntegerTypeRef;
    private static final ByteConverter.JsonTypeByteConverter MapStringIntegerByteConverter;

    Table(File directory, KeyStore.Impl storeImpl) throws IOException {
        this.directory = directory;
        LOGGER.info("Load table: " + directory);
        File dbFile = new File(directory, storeImpl.directoryName);
        try {
            this.keyStore = storeImpl.storeClass.getConstructor(File.class).newInstance(dbFile);
        }
        catch (ReflectiveOperationException e) {
            throw new ServerException(e);
        }
        this.columnDefsKey = new ColumnDefsKey();
        this.primaryIndexKey = new PrimaryIndexKey();
    }

    void closeNoLock() throws IOException {
        this.keyStore.close();
    }

    @Override
    public void close() throws IOException {
        this.closeNoLock();
        Tables.close(this.directory);
    }

    public void delete() throws IOException {
        if (this.keyStore.exists()) {
            this.keyStore.delete();
        }
    }

    public Map<String, ColumnDefinition> getColumns() throws IOException {
        return this.rwlColumns.readEx(() -> {
            Map<String, ColumnDefinition.Internal> map = this.columnDefsKey.getColumns(this.keyStore);
            LinkedHashMap res = new LinkedHashMap();
            map.forEach((s, columnInternalDefinition) -> res.put(s, new ColumnDefinition((ColumnDefinition)columnInternalDefinition)));
            return res;
        });
    }

    private void addColumn(Map<String, ColumnDefinition.Internal> columns, String columnName, ColumnDefinition columnDefinition) throws IOException {
        BitSet bitset = new BitSet();
        if (columns != null) {
            columns.forEach((s, columnInternalDefinition) -> bitset.set(columnInternalDefinition.column_id));
        }
        int columnId = bitset.nextClearBit(0);
        new ColumnDefKey(columnName).setValue(this.keyStore, new ColumnDefinition.Internal(columnDefinition, columnId));
    }

    public final void setColumn(String columnName, ColumnDefinition columnDefinition) throws IOException {
        this.rwlColumns.writeEx(() -> {
            ColumnDefinition.Internal oldColDef;
            Map<String, ColumnDefinition.Internal> columns = this.columnDefsKey.getColumns(this.keyStore);
            if (columns != null && (oldColDef = columns.get(columnName)) != null) {
                if (oldColDef.mode == columnDefinition.mode && oldColDef.type == columnDefinition.type) {
                    return;
                }
                throw new ServerException(Response.Status.NOT_ACCEPTABLE, "The column cannot be changed.");
            }
            this.addColumn(columns, columnName, columnDefinition);
        });
    }

    public final void removeColumn(String columnName) throws IOException {
        this.rwlColumns.writeEx(() -> {
            ColumnDefKey columnDefKey = new ColumnDefKey(columnName);
            ColumnDefinition.Internal colDef = (ColumnDefinition.Internal)columnDefKey.getValue(this.keyStore);
            if (colDef == null) {
                throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Cannot delete an unknown column: " + columnName);
            }
            new ColumnStoresKey(colDef.column_id).deleteAll(this.keyStore);
            new ColumnIndexesKey(colDef).deleteAll(this.keyStore);
            columnDefKey.deleteValue(this.keyStore);
        });
    }

    private void deleteRow(int docId) throws IOException {
        this.rwlColumns.readEx(() -> {
            for (ColumnDefinition.Internal colDef : this.columnDefsKey.getColumns(this.keyStore).values()) {
                ColumnStoreKey<?> columnStoreKey = ColumnStoreKey.newInstance(colDef, docId);
                if (colDef.mode == ColumnDefinition.Mode.INDEXED) {
                    new ColumnIndexesKey(colDef).remove(this.keyStore, columnStoreKey);
                }
                columnStoreKey.deleteValue(this.keyStore);
            }
        });
    }

    public final LinkedHashMap<String, Object> getRow(String key, Set<String> columnNames) throws IOException {
        if (key == null) {
            return null;
        }
        Integer docId = (Integer)new PrimaryIdsKey(key).getValue(this.keyStore);
        if (docId == null) {
            return null;
        }
        return this.rwlColumns.readEx(() -> {
            Map<String, ColumnDefinition.Internal> columns = columnNames == null || columnNames.isEmpty() ? this.columnDefsKey.getColumns(this.keyStore) : this.getColumns(columnNames);
            return this.getRowByIdNoLock(docId, columns);
        });
    }

    public final boolean deleteRow(String key) throws IOException {
        if (key == null) {
            throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Cannot delete an empty key");
        }
        PrimaryIdsKey primaryIdsKey = new PrimaryIdsKey(key);
        Integer docId = (Integer)primaryIdsKey.getValue(this.keyStore);
        if (docId == null) {
            return false;
        }
        this.deleteRow(docId);
        this.primaryIndexKey.remove(this.keyStore, docId);
        primaryIdsKey.deleteValue(this.keyStore);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upsertRowNoCommit(String key, Map<String, Object> row) throws IOException {
        AtomicBoolean newDocIdUsed;
        PrimaryIdsKey primaryIdsKey;
        Integer tempId;
        if (row == null) {
            return false;
        }
        if (key == null) {
            Object o = row.get("$id$");
            if (o != null) {
                key = o.toString();
            }
            if (key == null) {
                throw new ServerException(Response.Status.NOT_ACCEPTABLE, "The primary key is missing ($id$)");
            }
        }
        if ((tempId = (Integer)(primaryIdsKey = new PrimaryIdsKey(key)).getValue(this.keyStore)) == null) {
            tempId = this.primaryIndexKey.nextDocId(this.keyStore, key);
            newDocIdUsed = new AtomicBoolean(false);
        } else {
            newDocIdUsed = null;
        }
        int docId = tempId;
        try {
            boolean bl = this.rwlColumns.readEx(() -> {
                Map<String, ColumnDefinition.Internal> columns = this.columnDefsKey.getColumns(this.keyStore);
                for (Map.Entry entry : row.entrySet()) {
                    String colName = (String)entry.getKey();
                    if ("$id$".equals(colName)) continue;
                    ColumnDefinition.Internal colDef = columns.get(colName);
                    if (colDef == null) {
                        throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Unknown column: " + colName);
                    }
                    ColumnStoreKey<?> columnStoreKey = ColumnStoreKey.newInstance(colDef, docId);
                    Object valueObject = entry.getValue();
                    if (colDef.mode == ColumnDefinition.Mode.INDEXED) {
                        ColumnIndexesKey columnIndexesKey = new ColumnIndexesKey(colDef);
                        columnIndexesKey.remove(this.keyStore, columnStoreKey);
                        columnIndexesKey.select(this.keyStore, valueObject, docId);
                    }
                    columnStoreKey.setObjectValue(this.keyStore, valueObject);
                }
                this.primaryIndexKey.select(this.keyStore, docId);
                if (newDocIdUsed != null) {
                    newDocIdUsed.set(true);
                }
                return true;
            });
            return bl;
        }
        finally {
            if (newDocIdUsed != null && !newDocIdUsed.get()) {
                this.primaryIndexKey.remove(this.keyStore, docId);
            }
        }
    }

    public final boolean upsertRow(String key, Map<String, Object> row) throws IOException {
        return this.upsertRowNoCommit(key, row);
    }

    public final int upsertRows(Collection<Map<String, Object>> rows) throws IOException {
        int count = 0;
        for (Map<String, Object> row : rows) {
            if (!this.upsertRowNoCommit(null, row)) continue;
            ++count;
        }
        return count;
    }

    public final int getSize() throws IOException {
        RoaringBitmap bitmap = (RoaringBitmap)this.primaryIndexKey.getValue(this.keyStore);
        return bitmap == null ? 0 : bitmap.getCardinality();
    }

    private Map<String, ColumnDefinition.Internal> getColumns(Set<String> columnNames) throws IOException {
        if (columnNames == null || columnNames.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, ColumnDefinition.Internal> columnDefs = this.columnDefsKey.getColumns(this.keyStore);
        LinkedHashMap<String, ColumnDefinition.Internal> columns = new LinkedHashMap<String, ColumnDefinition.Internal>();
        for (String columnName : columnNames) {
            ColumnDefinition.Internal columnDef = columnDefs.get(columnName);
            if (columnDef == null) {
                if (columnName.equals("$id$")) {
                    columnDef = ColumnDefinition.Internal.PRIMARYKEY_COLUMN;
                } else {
                    throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Column not found: " + columnName);
                }
            }
            columns.put(columnName, columnDef);
        }
        return columns;
    }

    private LinkedHashMap<String, Object> getRowByIdNoLock(Integer docId, Map<String, ColumnDefinition.Internal> columns) throws IOException {
        if (docId == null) {
            return null;
        }
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        columns.forEach((name, internal) -> {
            try {
                String value = internal == ColumnDefinition.Internal.PRIMARYKEY_COLUMN ? this.primaryIndexKey.getKey(this.keyStore, docId) : ColumnStoreKey.newInstance(internal, docId).getValue(this.keyStore);
                row.put((String)name, value);
            }
            catch (IOException e) {
                throw new ServerException(e);
            }
        });
        return row;
    }

    public final void getRows(RoaringBitmap bitmap, Set<String> columnNames, long start, long rows, List<Map<String, Object>> results) throws IOException {
        if (bitmap == null || bitmap.isEmpty()) {
            return;
        }
        this.rwlColumns.readEx(() -> {
            Map<String, ColumnDefinition.Internal> columns = this.getColumns(columnNames);
            PeekableIntIterator docIterator = bitmap.getIntIterator();
            long s = start;
            while (s-- > 0L && docIterator.hasNext()) {
                docIterator.next();
            }
            long r = rows;
            while (r-- > 0L && docIterator.hasNext()) {
                LinkedHashMap<String, Object> row = this.getRowByIdNoLock(docIterator.next(), columns);
                if (row == null) continue;
                results.add(row);
            }
        });
    }

    public final void getRows(Set<String> keys, Set<String> columnNames, List<Map<String, Object>> results) throws IOException {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        ArrayList<Integer> ids = new ArrayList<Integer>(keys.size());
        PrimaryIdsKey.fillExistingIds(this.keyStore, keys, ids);
        if (ids == null || ids.isEmpty()) {
            return;
        }
        this.rwlColumns.readEx(() -> {
            Map<String, ColumnDefinition.Internal> columns = this.getColumns(columnNames);
            for (Integer id : ids) {
                LinkedHashMap<String, Object> row = this.getRowByIdNoLock(id, columns);
                if (row == null) continue;
                results.add(row);
            }
        });
    }

    public final List<String> getPrimaryKeys(int start, int rows) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(rows);
        this.primaryIndexKey.fillKeys(this.keyStore, start, rows, ((RoaringBitmap)this.primaryIndexKey.getValue(this.keyStore)).getIntIterator(), keys::add);
        return keys;
    }

    private ColumnDefinition.Internal getIndexedColumn(String columnName) throws IOException {
        ColumnDefinition.Internal columnDef = (ColumnDefinition.Internal)new ColumnDefKey(columnName).getValue(this.keyStore);
        if (columnDef == null) {
            throw new ServerException(Response.Status.NOT_FOUND, "Column not found: " + columnName);
        }
        if (columnDef.mode != ColumnDefinition.Mode.INDEXED) {
            throw new ServerException(Response.Status.NOT_ACCEPTABLE, "The column is not indexed: " + columnName);
        }
        return columnDef;
    }

    public final List<Object> getColumnTerms(String columnName, int start, int rows) throws IOException {
        return this.rwlColumns.readEx(() -> {
            ColumnIndexKey<?> indexKey = ColumnIndexKey.newInstance(this.getIndexedColumn(columnName), null);
            return indexKey.getValues(this.keyStore, start, rows);
        });
    }

    public final List<String> getColumnTermKeys(String columnName, Object term, int start, int rows) throws IOException {
        return this.rwlColumns.readEx(() -> {
            ColumnIndexKey<?> indexKey = ColumnIndexKey.newInstance(this.getIndexedColumn(columnName), term);
            ArrayList keys = new ArrayList();
            RoaringBitmap columnBitmap = (RoaringBitmap)indexKey.getValue(this.keyStore);
            if (columnBitmap == null || columnBitmap.isEmpty()) {
                return keys;
            }
            this.primaryIndexKey.fillKeys(this.keyStore, start, rows, columnBitmap.getIntIterator(), keys::add);
            return keys;
        });
    }

    public final QueryContext getNewQueryContext() throws IOException {
        return new QueryContext(this.keyStore, this.columnDefsKey.getColumns(this.keyStore));
    }

    public final QueryResult query(Query query, Map<String, Map<String, CollectorInterface.LongCounter>> facets) throws IOException {
        return this.rwlColumns.readEx(() -> {
            RoaringBitmap finalBitmap;
            QueryContext context = this.getNewQueryContext();
            RoaringBitmap roaringBitmap = finalBitmap = query != null ? query.execute(context, readExecutor) : (RoaringBitmap)this.primaryIndexKey.getValue(this.keyStore);
            if (finalBitmap == null || finalBitmap.isEmpty()) {
                return new QueryResult(context, finalBitmap);
            }
            CollectorInterface collector = CollectorInterface.build();
            if (facets != null) {
                HashMap<String, HashMap<Object, CollectorInterface.LongCounter>> facetsMap = new HashMap<String, HashMap<Object, CollectorInterface.LongCounter>>();
                for (Map.Entry entry : facets.entrySet()) {
                    String facetField = (String)entry.getKey();
                    HashMap<Object, CollectorInterface.LongCounter> facetMap = new HashMap<Object, CollectorInterface.LongCounter>();
                    facetsMap.put(facetField, facetMap);
                    collector = context.newFacetCollector(collector, facetField, facetMap);
                }
            } else {
                Object facetsMap = null;
            }
            collector.collect(finalBitmap);
            return new QueryResult(context, finalBitmap);
        });
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                readExecutor.shutdown();
                writeExecutor.shutdown();
            }
        });
        MapStringIntegerTypeRef = new TypeReference<Map<String, Integer>>(){};
        MapStringIntegerByteConverter = new ByteConverter.JsonTypeByteConverter<Map<String, Integer>>(MapStringIntegerTypeRef);
    }
}

