/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store;

import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.Table;
import com.qwazr.server.ServerException;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tables {
    private static final Logger LOGGER = LoggerFactory.getLogger(Table.class);
    private static final ConcurrentHashMap<File, Table> tables = new ConcurrentHashMap();

    public static Table getInstance(File directory, KeyStore.Impl storeImpl) {
        return tables.computeIfAbsent(directory, file -> {
            KeyStore.Impl si;
            KeyStore.Impl impl = si = storeImpl == null ? KeyStore.Impl.detect(directory) : storeImpl;
            if (si == null) {
                throw new ServerException("Cannot detect the store type: " + directory);
            }
            try {
                return new Table((File)file, si);
            }
            catch (IOException e) {
                throw new ServerException(e);
            }
        });
    }

    public static void delete(File directory) throws IOException {
        Table table = tables.get(directory);
        if (table == null) {
            return;
        }
        table.close();
        table.delete();
    }

    static synchronized void close(File directory) throws IOException {
        Table table = tables.remove(directory);
        if (table == null) {
            return;
        }
        table.closeNoLock();
    }

    public static void closeAll() {
        tables.forEach((file, table) -> {
            try {
                table.closeNoLock();
            }
            catch (IOException e) {
                LOGGER.warn("Cannot clause the table: " + table, e);
            }
        });
        tables.clear();
    }
}

