/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store.keys;

import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.store.ByteConverter;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.keys.IndexKey;
import com.qwazr.database.store.keys.KeyEnum;
import com.qwazr.server.ServerException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;

public class ColumnIndexKey<V>
extends IndexKey {
    private final int columnId;
    private final V value;
    private final ByteConverter<V> valueByteConverter;

    private ColumnIndexKey(int columnId, Object value, ByteConverter<V> valueByteConverter) throws IOException {
        super(KeyEnum.COLUMN_INDEX);
        this.columnId = columnId;
        this.value = value == null ? null : valueByteConverter.convert(value);
        this.valueByteConverter = valueByteConverter;
    }

    @Override
    public final void buildKey(DataOutputStream output) throws IOException {
        super.buildKey(output);
        output.writeInt(this.columnId);
        if (this.value != null) {
            output.write(this.valueByteConverter.toBytes(this.value));
        }
    }

    public List<Object> getValues(KeyStore store, int start, int rows) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        byte[] prefixKey = this.getCachedKey();
        this.prefixedKeys(store, start, rows, (key, value) -> {
            ByteBuffer valueBytes = ByteBuffer.wrap(key, prefixKey.length, ((byte[])key).length - prefixKey.length);
            values.add(this.valueByteConverter.toValue(valueBytes));
        });
        return values;
    }

    public static final ColumnIndexKey<?> newInstance(ColumnDefinition.Internal colDef, Object value) throws IOException {
        switch (colDef.type) {
            case DOUBLE: {
                return new ColumnIndexKey<Double>(colDef.column_id, value, ByteConverter.DoubleByteConverter.INSTANCE);
            }
            case INTEGER: {
                return new ColumnIndexKey<Integer>(colDef.column_id, value, ByteConverter.IntegerByteConverter.INSTANCE);
            }
            case LONG: {
                return new ColumnIndexKey<Long>(colDef.column_id, value, ByteConverter.LongByteConverter.INSTANCE);
            }
            case STRING: {
                return new ColumnIndexKey<String>(colDef.column_id, value, ByteConverter.StringByteConverter.INSTANCE);
            }
        }
        throw new ServerException(Response.Status.NOT_ACCEPTABLE, "unknown type: " + (Object)((Object)colDef.type));
    }
}

