/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store.keys;

import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.keys.ColumnIndexKey;
import com.qwazr.database.store.keys.ColumnStoreKey;
import com.qwazr.database.store.keys.KeyEnum;
import com.qwazr.database.store.keys.KeysAbstract;
import com.qwazr.server.ServerException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import javax.ws.rs.core.Response;

public class ColumnIndexesKey
extends KeysAbstract {
    private final ColumnDefinition.Internal colDef;
    private final ArrayIterator arrayIterator;

    public ColumnIndexesKey(ColumnDefinition.Internal colDef) {
        super(KeyEnum.COLUMN_INDEX);
        this.colDef = colDef;
        switch (colDef.type) {
            case STRING: {
                this.arrayIterator = new StringArrayIterator();
                break;
            }
            case LONG: {
                this.arrayIterator = new LongArrayIterator();
                break;
            }
            case INTEGER: {
                this.arrayIterator = new IntArrayIterator();
                break;
            }
            case DOUBLE: {
                this.arrayIterator = new DoubleArrayIterator();
                break;
            }
            default: {
                throw new ServerException(Response.Status.NOT_ACCEPTABLE, "Unsupported type: " + (Object)((Object)colDef.type));
            }
        }
    }

    @Override
    public final void buildKey(DataOutputStream output) throws IOException {
        super.buildKey(output);
        output.writeInt(this.colDef.column_id);
    }

    public final void remove(KeyStore store, ColumnStoreKey<?> columnStoreKey) throws IOException {
        Object value = columnStoreKey.getValue(store);
        if (value == null) {
            return;
        }
        this.arrayIterator.remove(store, value, columnStoreKey.docId);
    }

    public final void select(KeyStore store, Object value, int docId) throws IOException {
        if (value instanceof Collection) {
            for (Object val : (Collection)value) {
                ColumnIndexKey.newInstance(this.colDef, val).select(store, docId);
            }
        } else if (value.getClass().isArray()) {
            for (Object val : (Object[])value) {
                ColumnIndexKey.newInstance(this.colDef, val).select(store, docId);
            }
        } else {
            ColumnIndexKey.newInstance(this.colDef, value).select(store, docId);
        }
    }

    private class StringArrayIterator
    extends ArrayIterator {
        private StringArrayIterator() {
        }

        @Override
        protected final void remove(KeyStore store, Object object, int docId) throws IOException {
            String[] array;
            for (String value : array = (String[])object) {
                ColumnIndexKey.newInstance(ColumnIndexesKey.this.colDef, value).remove(store, docId);
            }
        }
    }

    private class LongArrayIterator
    extends ArrayIterator {
        private LongArrayIterator() {
        }

        @Override
        protected final void remove(KeyStore store, Object object, int docId) throws IOException {
            long[] array;
            for (long value : array = (long[])object) {
                ColumnIndexKey.newInstance(ColumnIndexesKey.this.colDef, value).remove(store, docId);
            }
        }
    }

    private class DoubleArrayIterator
    extends ArrayIterator {
        private DoubleArrayIterator() {
        }

        @Override
        protected final void remove(KeyStore store, Object object, int docId) throws IOException {
            double[] array;
            for (double value : array = (double[])object) {
                ColumnIndexKey.newInstance(ColumnIndexesKey.this.colDef, value).remove(store, docId);
            }
        }
    }

    private class IntArrayIterator
    extends ArrayIterator {
        private IntArrayIterator() {
        }

        @Override
        protected void remove(KeyStore store, Object object, int docId) throws IOException {
            int[] array;
            for (int value : array = (int[])object) {
                ColumnIndexKey.newInstance(ColumnIndexesKey.this.colDef, value).remove(store, docId);
            }
        }
    }

    private abstract class ArrayIterator {
        private ArrayIterator() {
        }

        protected abstract void remove(KeyStore var1, Object var2, int var3) throws IOException;
    }
}

