/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store.keys;

import com.qwazr.database.model.ColumnDefinition;
import com.qwazr.database.store.ByteConverter;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.ValueConsumer;
import com.qwazr.database.store.keys.KeyAbstract;
import com.qwazr.database.store.keys.KeyEnum;
import com.qwazr.server.ServerException;
import com.qwazr.utils.ArrayUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import javax.ws.rs.core.Response;

public final class ColumnStoreKey<V>
extends KeyAbstract<V> {
    final ColumnDefinition.Internal columnDef;
    final int docId;

    protected ColumnStoreKey(ColumnDefinition.Internal columnDef, int docId, ByteConverter<V> byteConverter) {
        super(KeyEnum.COLUMN_STORE, byteConverter);
        this.docId = docId;
        this.columnDef = columnDef;
    }

    @Override
    public final void buildKey(DataOutputStream output) throws IOException {
        super.buildKey(output);
        output.writeInt(this.columnDef.column_id);
        output.writeInt(this.docId);
    }

    public final void forEach(KeyStore store, ValueConsumer consumer) throws IOException {
        this.byteConverter.forEach(this.getValue(store), consumer);
    }

    public final void forFirst(KeyStore store, ValueConsumer consumer) throws IOException {
        this.byteConverter.forFirst(this.getValue(store), consumer);
    }

    public static final ColumnStoreKey<?> newInstance(ColumnDefinition.Internal colDef, int docId) {
        switch (colDef.type) {
            case DOUBLE: {
                return new ColumnStoreKey<double[]>(colDef, docId, ByteConverter.DoubleArrayByteConverter.INSTANCE);
            }
            case INTEGER: {
                return new ColumnStoreKey<int[]>(colDef, docId, ByteConverter.IntArrayByteConverter.INSTANCE);
            }
            case LONG: {
                return new ColumnStoreKey<long[]>(colDef, docId, ByteConverter.LongArrayByteConverter.INSTANCE);
            }
            case STRING: {
                return new ColumnStoreKey<String[]>(colDef, docId, ByteConverter.StringArrayByteConverter.INSTANCE);
            }
        }
        throw new ServerException(Response.Status.NOT_ACCEPTABLE, "unknown type: " + (Object)((Object)colDef.type));
    }

    public final void setObjectValue(KeyStore store, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof Collection) {
            this.setValue(store, this.collectionToArray((Collection)value));
        } else if (value.getClass().isArray()) {
            this.setValue(store, value);
        } else {
            this.setValue(store, this.objectToArray(value));
        }
    }

    private Object collectionToArray(Collection<?> collection) {
        switch (this.columnDef.type) {
            case DOUBLE: {
                return ArrayUtils.toPrimitiveDouble(collection);
            }
            case INTEGER: {
                return ArrayUtils.toPrimitiveInt(collection);
            }
            case LONG: {
                return ArrayUtils.toPrimitiveLong(collection);
            }
            case STRING: {
                return collection.toArray(new String[collection.size()]);
            }
        }
        throw new ServerException(Response.Status.NOT_ACCEPTABLE, "unknown type: " + (Object)((Object)this.columnDef.type));
    }

    private Object objectToArray(Object object) {
        switch (this.columnDef.type) {
            case DOUBLE: {
                return new double[]{(Double)object};
            }
            case INTEGER: {
                return new int[]{(Integer)object};
            }
            case LONG: {
                return new long[]{(Long)object};
            }
            case STRING: {
                return new String[]{(String)object};
            }
        }
        throw new ServerException(Response.Status.NOT_ACCEPTABLE, "unknown type: " + (Object)((Object)this.columnDef.type));
    }
}

