/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store.keys;

import com.qwazr.database.store.ByteConverter;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.keys.KeyAbstract;
import com.qwazr.database.store.keys.KeyEnum;
import java.io.IOException;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class IndexKey
extends KeyAbstract<RoaringBitmap> {
    static final ByteConverter.SerializableByteConverter<RoaringBitmap> roaringBitmapConverter = new ByteConverter.SerializableByteConverter();

    public IndexKey(KeyEnum keyType) {
        super(keyType, roaringBitmapConverter);
    }

    public void remove(KeyStore store, int docId) throws IOException {
        RoaringBitmap bitmap = (RoaringBitmap)this.getValue(store);
        if (bitmap == null) {
            return;
        }
        bitmap.remove(docId);
        if (bitmap.isEmpty()) {
            this.deleteValue(store);
        } else {
            this.setValue(store, bitmap);
        }
    }

    public final void select(KeyStore store, int docId) throws IOException {
        RoaringBitmap bitmap = (RoaringBitmap)this.getValue(store);
        if (bitmap == null) {
            bitmap = new RoaringBitmap();
        }
        bitmap.add(docId);
        this.setValue(store, bitmap);
    }

    protected final Integer nextDocId(KeyStore store) throws IOException {
        RoaringBitmap bitmap = (RoaringBitmap)this.getValue(store);
        if (bitmap == null || bitmap.isEmpty()) {
            return 0;
        }
        IntIterator reverseIterator = bitmap.getReverseIntIterator();
        int nexHigherId = reverseIterator.next() + 1;
        RoaringBitmap inverseBitmap = bitmap.clone();
        inverseBitmap.flip(0L, (long)nexHigherId);
        PeekableIntIterator inverseIterator = inverseBitmap.getIntIterator();
        if (inverseIterator.hasNext()) {
            return inverseIterator.next();
        }
        return nexHigherId;
    }
}

