/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store.keys;

import com.qwazr.database.store.ByteConverter;
import com.qwazr.database.store.KeyIterator;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.keys.KeyEnum;
import com.qwazr.database.store.keys.KeyInterface;
import com.qwazr.utils.ArrayUtils;
import com.qwazr.utils.FunctionUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public abstract class KeyAbstract<V>
implements KeyInterface<V> {
    private final KeyEnum keyType;
    protected final ByteConverter<V> byteConverter;
    private byte[] keyBytes;

    protected KeyAbstract(KeyEnum keyType, ByteConverter<V> byteConverter) {
        this.keyType = keyType;
        this.byteConverter = byteConverter;
        this.keyBytes = null;
    }

    @Override
    public void buildKey(DataOutputStream output) throws IOException {
        output.writeChar(this.keyType.id);
    }

    /*
     * Exception decompiling
     */
    @Override
    public final synchronized byte[] getCachedKey() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final V getValue(KeyStore store) throws IOException {
        byte[] bytes = store.get(this.getCachedKey());
        if (bytes == null) {
            return null;
        }
        return this.byteConverter.toValue(bytes);
    }

    @Override
    public final void setValue(KeyStore store, V value) throws IOException {
        store.put(this.getCachedKey(), this.byteConverter.toBytes(value));
    }

    @Override
    public final void deleteValue(KeyStore store) throws IOException {
        store.delete(this.getCachedKey());
    }

    @Override
    public final void prefixedKeys(KeyStore store, int start, int rows, FunctionUtils.BiConsumerEx<byte[], byte[], IOException> consumer) throws IOException {
        byte[] prefixKey = this.getCachedKey();
        try (KeyIterator iterator = store.iterator(prefixKey);){
            Map.Entry entry;
            while (start-- > 0 && iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                if (ArrayUtils.startsWith((byte[])entry.getKey(), prefixKey)) continue;
                return;
            }
            while (rows-- > 0 && iterator.hasNext()) {
                entry = (Map.Entry)iterator.next();
                byte[] key = (byte[])entry.getKey();
                if (!ArrayUtils.startsWith(key, prefixKey)) {
                    return;
                }
                consumer.accept(key, (byte[])entry.getValue());
            }
        }
    }
}

