/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store.keys;

import com.qwazr.database.store.KeyIterator;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.keys.KeyAbstract;
import com.qwazr.database.store.keys.KeyEnum;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;

public abstract class KeysAbstract<T>
extends KeyAbstract<T> {
    public KeysAbstract(KeyEnum keyType) {
        super(keyType, null);
    }

    public final int deleteAll(KeyStore store) throws IOException {
        byte[] myKey = this.getCachedKey();
        ByteBuffer bb = ByteBuffer.wrap(myKey);
        try (KeyIterator iterator = store.iterator(myKey);){
            Map.Entry entry;
            byte[] key;
            int count = 0;
            while (iterator.hasNext() && (key = (byte[])(entry = (Map.Entry)iterator.next()).getKey()).length >= myKey.length && bb.equals(ByteBuffer.wrap(key, 0, myKey.length))) {
                store.delete(key);
                ++count;
            }
            int n = count;
            return n;
        }
    }
}

