/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store.keys;

import com.qwazr.database.store.ByteConverter;
import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.keys.KeyAbstract;
import com.qwazr.database.store.keys.KeyEnum;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class PrimaryIdsKey
extends KeyAbstract<Integer> {
    private final String key;

    public PrimaryIdsKey(String key) {
        super(KeyEnum.PRIMARY_IDS, ByteConverter.IntegerByteConverter.INSTANCE);
        this.key = key;
    }

    @Override
    public void buildKey(DataOutputStream output) throws IOException {
        super.buildKey(output);
        output.writeChars(this.key);
    }

    public static final void fillExistingIds(KeyStore store, Set<String> keys, Collection<Integer> ids) throws IOException {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            Integer id = (Integer)new PrimaryIdsKey(key).getValue(store);
            if (id == null) continue;
            ids.add(id);
        }
    }
}

