/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.database.store.keys;

import com.qwazr.database.store.KeyStore;
import com.qwazr.database.store.keys.IndexKey;
import com.qwazr.database.store.keys.KeyEnum;
import com.qwazr.database.store.keys.PrimaryIdsKey;
import com.qwazr.database.store.keys.PrimaryKeysKey;
import com.qwazr.utils.FunctionUtils;
import java.io.IOException;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class PrimaryIndexKey
extends IndexKey {
    public PrimaryIndexKey() {
        super(KeyEnum.PRIMARY_INDEX);
    }

    public final Integer nextDocId(KeyStore store, String key) throws IOException {
        int docId = super.nextDocId(store);
        new PrimaryIdsKey(key).setValue(store, docId);
        new PrimaryKeysKey(docId).setValue(store, key);
        return docId;
    }

    @Override
    public final void remove(KeyStore store, int docId) throws IOException {
        String key = this.getKey(store, docId);
        if (key != null) {
            new PrimaryIdsKey(key).deleteValue(store);
        }
        new PrimaryKeysKey(docId).deleteValue(store);
        super.remove(store, docId);
    }

    public final String getKey(KeyStore store, int docId) throws IOException {
        return (String)new PrimaryKeysKey(docId).getValue(store);
    }

    public final void fillKeys(KeyStore store, int start, int rows, IntIterator iterator, FunctionUtils.ConsumerEx<String, IOException> keyConsumer) throws IOException {
        while (iterator.hasNext() && start-- > 0) {
            iterator.next();
        }
        while (iterator.hasNext() && rows-- > 0) {
            keyConsumer.accept(this.getKey(store, iterator.next()));
        }
    }

    public final void remove(KeyStore store, RoaringBitmap finalBitmap) throws IOException {
        if (finalBitmap == null || finalBitmap.isEmpty()) {
            return;
        }
        PeekableIntIterator intIterator = finalBitmap.getIntIterator();
        while (intIterator.hasNext()) {
            this.remove(store, intIterator.next());
        }
    }
}

