/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.externalizor;

import com.qwazr.externalizor.Externalizer;
import com.qwazr.externalizor.FieldExternalizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import org.roaringbitmap.RoaringBitmap;
import org.xerial.snappy.Snappy;

interface ArrayExternalizer<T, V>
extends Externalizer<T, V> {
    public static FieldExternalizer array(Field field, Class<?> clazz) {
        Externalizer externalizer;
        Class<?> componentType = clazz.getComponentType();
        if (componentType.isPrimitive()) {
            if (Integer.TYPE.equals(componentType)) {
                return new FieldArrayIntegerExternalizer(field);
            }
            if (Short.TYPE.equals(componentType)) {
                return new FieldArrayShortExternalizer(field);
            }
            if (Long.TYPE.equals(componentType)) {
                return new FieldArrayLongExternalizer(field);
            }
            if (Float.TYPE.equals(componentType)) {
                return new FieldArrayFloatExternalizer(field);
            }
            if (Double.TYPE.equals(componentType)) {
                return new FieldArrayDoubleExternalizer(field);
            }
            if (Boolean.TYPE.equals(componentType)) {
                return new FieldArrayBooleanExternalizer(field);
            }
            if (Byte.TYPE.equals(componentType)) {
                return new FieldArrayByteExternalizer(field);
            }
            if (Character.TYPE.equals(componentType)) {
                return new FieldArrayCharExternalizer(field);
            }
        }
        if ((externalizer = Externalizer.of(componentType)) != null) {
            return new FieldArrayLangObjectExternalizer(field, componentType, externalizer);
        }
        return null;
    }

    public static void writeBytes(byte[] bytes, ObjectOutput out) throws IOException {
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static byte[] readBytes(ObjectInput in) throws IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        return bytes;
    }

    public static final class FieldArrayLangObjectExternalizer<T>
    extends FieldExternalizer.FieldObjectExternalizer<T, Object[]>
    implements ArrayExternalizer<T, Object[]> {
        private final Externalizer componentExternalizer;
        private final Class<?> componentType;

        FieldArrayLangObjectExternalizer(Field field, Class<?> componentType, Externalizer componentExternalizer) {
            super(field);
            this.componentExternalizer = componentExternalizer;
            this.componentType = componentType;
        }

        @Override
        public final Object[] readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            if (!in.readBoolean()) {
                return null;
            }
            Object[] array = (Object[])Array.newInstance(this.componentType, in.readInt());
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.componentExternalizer.readObject(in);
            }
            return array;
        }

        @Override
        protected final void writeValue(Object[] value, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeInt(value.length);
            for (Object item : value) {
                this.componentExternalizer.writeExternal(item, out);
            }
        }
    }

    public static final class FieldArrayBooleanExternalizer<T>
    extends FieldExternalizer.FieldObjectExternalizer<T, boolean[]> {
        private FieldArrayBooleanExternalizer(Field field) {
            super(field);
        }

        @Override
        public boolean[] readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            if (!in.readBoolean()) {
                return null;
            }
            boolean[] array = new boolean[in.readInt()];
            RoaringBitmap bitmap = new RoaringBitmap();
            bitmap.readExternal(in);
            bitmap.forEach(i -> {
                array[i] = true;
            });
            return array;
        }

        @Override
        protected final void writeValue(boolean[] value, ObjectOutput out) throws IOException {
            out.writeInt(value.length);
            RoaringBitmap bitmap = new RoaringBitmap();
            for (int i = 0; i < value.length; ++i) {
                if (!value[i]) continue;
                bitmap.add(i);
            }
            bitmap.writeExternal(out);
        }
    }

    public static final class FieldArrayCharExternalizer<T>
    extends FieldArraySnappyExternalizer<T, char[]> {
        private FieldArrayCharExternalizer(Field field) {
            super(field);
        }

        @Override
        protected final char[] uncompress(byte[] bytes) throws IOException {
            return Snappy.uncompressCharArray(bytes);
        }

        @Override
        protected final byte[] compress(char[] value) throws IOException {
            return Snappy.compress(value);
        }
    }

    public static final class FieldArrayByteExternalizer<T>
    extends FieldArraySnappyExternalizer<T, byte[]> {
        private FieldArrayByteExternalizer(Field field) {
            super(field);
        }

        @Override
        protected final byte[] uncompress(byte[] bytes) throws IOException {
            return Snappy.uncompress(bytes);
        }

        @Override
        protected final byte[] compress(byte[] value) throws IOException {
            return Snappy.compress(value);
        }
    }

    public static final class FieldArrayFloatExternalizer<T>
    extends FieldArraySnappyExternalizer<T, float[]> {
        private FieldArrayFloatExternalizer(Field field) {
            super(field);
        }

        @Override
        protected final float[] uncompress(byte[] bytes) throws IOException {
            return Snappy.uncompressFloatArray(bytes);
        }

        @Override
        protected final byte[] compress(float[] value) throws IOException {
            return Snappy.compress(value);
        }
    }

    public static final class FieldArrayDoubleExternalizer<T>
    extends FieldArraySnappyExternalizer<T, double[]> {
        private FieldArrayDoubleExternalizer(Field field) {
            super(field);
        }

        @Override
        protected final double[] uncompress(byte[] bytes) throws IOException {
            return Snappy.uncompressDoubleArray(bytes);
        }

        @Override
        protected final byte[] compress(double[] value) throws IOException {
            return Snappy.compress(value);
        }
    }

    public static final class FieldArrayShortExternalizer<T>
    extends FieldArraySnappyExternalizer<T, short[]> {
        private FieldArrayShortExternalizer(Field field) {
            super(field);
        }

        @Override
        protected final short[] uncompress(byte[] bytes) throws IOException {
            return Snappy.uncompressShortArray(bytes);
        }

        @Override
        protected final byte[] compress(short[] value) throws IOException {
            return Snappy.compress(value);
        }
    }

    public static final class FieldArrayLongExternalizer<T>
    extends FieldArraySnappyExternalizer<T, long[]> {
        private FieldArrayLongExternalizer(Field field) {
            super(field);
        }

        @Override
        protected final long[] uncompress(byte[] bytes) throws IOException {
            return Snappy.uncompressLongArray(bytes);
        }

        @Override
        protected final byte[] compress(long[] value) throws IOException {
            return Snappy.compress(value);
        }
    }

    public static final class FieldArrayIntegerExternalizer<T>
    extends FieldArraySnappyExternalizer<T, int[]> {
        private FieldArrayIntegerExternalizer(Field field) {
            super(field);
        }

        @Override
        protected final int[] uncompress(byte[] bytes) throws IOException {
            return Snappy.uncompressIntArray(bytes);
        }

        @Override
        protected final byte[] compress(int[] value) throws IOException {
            return Snappy.compress(value);
        }
    }

    public static abstract class FieldArraySnappyExternalizer<T, V>
    extends FieldExternalizer.FieldObjectExternalizer<T, V> {
        protected FieldArraySnappyExternalizer(Field field) {
            super(field);
        }

        protected abstract V uncompress(byte[] var1) throws IOException;

        protected abstract byte[] compress(V var1) throws IOException;

        @Override
        protected final void writeValue(V value, ObjectOutput out) throws IOException, ReflectiveOperationException {
            ArrayExternalizer.writeBytes(this.compress(value), out);
        }

        @Override
        public final V readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            if (!in.readBoolean()) {
                return null;
            }
            return this.uncompress(ArrayExternalizer.readBytes(in));
        }
    }
}

