/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.externalizor;

import com.qwazr.externalizor.Externalizer;
import com.qwazr.externalizor.ExternalizorException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;

interface ClassExternalizer<T>
extends Externalizer<T, T> {
    public static <T> ClassExternalizer<T> of(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            ArrayList<Externalizer> externalizers = new ArrayList<Externalizer>();
            ClassExternalizer.detectFields(clazz, externalizers);
            if (externalizers.size() > 0) {
                return new RootExternalizer(constructor, externalizers);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return new SerializableExternalizer(clazz);
        }
        throw new ExternalizorException("Externalizer does not support serialization of: " + clazz);
    }

    public static void detectFields(Class<?> clazz, Collection<Externalizer> externalizers) {
        Field[] fields;
        if (clazz == null) {
            return;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            Class<?> cl = field.getType();
            int modifier = field.getModifiers();
            if (Modifier.isStatic(modifier) || Modifier.isTransient(modifier)) continue;
            field.setAccessible(true);
            Externalizer fieldExt = Externalizer.of(field, cl);
            externalizers.add(fieldExt);
        }
        ClassExternalizer.detectFields(clazz.getSuperclass(), externalizers);
    }

    public static final class SerializableExternalizer<T>
    implements ClassExternalizer<T> {
        private final Class<T> clazz;

        private SerializableExternalizer(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeObject(object);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            throw new ExternalizorException("Cannot read external from " + this.clazz);
        }

        @Override
        public T readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            return (T)(in.readBoolean() ? in.readObject() : null);
        }
    }

    public static final class RootExternalizer<T>
    implements ClassExternalizer<T> {
        private final Constructor<T> constructor;
        private final Collection<Externalizer> externalizers;

        private RootExternalizer(Constructor<T> constructor, Collection<Externalizer> externalizers) {
            this.constructor = constructor;
            this.externalizers = externalizers;
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            for (Externalizer externalizer : this.externalizers) {
                externalizer.writeExternal(object, out);
            }
        }

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            for (Externalizer externalizer : this.externalizers) {
                externalizer.readExternal(object, in);
            }
        }

        @Override
        public final T readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            T object = this.constructor.newInstance(new Object[0]);
            this.readExternal(object, in);
            return object;
        }
    }
}

