/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.externalizor;

import com.qwazr.externalizor.ArrayExternalizer;
import com.qwazr.externalizor.Externalizer;
import com.qwazr.externalizor.ExternalizorException;
import com.qwazr.externalizor.FieldExternalizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.roaringbitmap.RoaringBitmap;
import org.xerial.snappy.Snappy;

interface CollectionExternalizer<T, V>
extends Externalizer<T, V> {
    public static <T, V> CollectionExternalizer<T, V> collection(Field field, Class<? extends T> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return new FieldMapExternalizer(field, clazz);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Class<?> genericClass = FieldExternalizer.getGenericClass(field, 0);
            if (Long.class.isAssignableFrom(genericClass)) {
                return new FieldCollectionLongExternalizer(field, (Class<? extends Collection<Long>>)((Class<Collection<Long>>)clazz));
            }
            if (Integer.class.isAssignableFrom(genericClass)) {
                return new FieldCollectionIntegerExternalizer(field, (Class<? extends Collection<Integer>>)((Class<Collection<Integer>>)clazz));
            }
            if (Short.class.isAssignableFrom(genericClass)) {
                return new FieldCollectionShortExternalizer(field, (Class<? extends Collection<Short>>)((Class<Collection<Short>>)clazz));
            }
            if (Double.class.isAssignableFrom(genericClass)) {
                return new FieldCollectionDoubleExternalizer(field, (Class<? extends Collection<Double>>)((Class<Collection<Double>>)clazz));
            }
            if (Float.class.isAssignableFrom(genericClass)) {
                return new FieldCollectionFloatExternalizer(field, (Class<? extends Collection<Float>>)((Class<Collection<Float>>)clazz));
            }
            if (Character.class.isAssignableFrom(genericClass)) {
                return new FieldCollectionCharacterExternalizer(field, (Class<? extends Collection<Character>>)((Class<Collection<Character>>)clazz));
            }
            if (Byte.class.isAssignableFrom(genericClass)) {
                return new FieldCollectionByteExternalizer(field, (Class<? extends Collection<Byte>>)((Class<Collection<Byte>>)clazz));
            }
            if (Boolean.class.isAssignableFrom(genericClass)) {
                return new FieldCollectionBooleanExternalizer(field, (Class<? extends Collection<Boolean>>)((Class<Collection<Boolean>>)clazz));
            }
            return new FieldCollectionExternalizer(field, (Class<? extends Collection<?>>)((Class<Collection<?>>)clazz));
        }
        return null;
    }

    public static Class<?> collectionClass(Class<?> clazz) {
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            return clazz;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return LinkedHashSet.class;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return ArrayList.class;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return LinkedHashMap.class;
        }
        throw new ExternalizorException("Collection not supported: " + clazz);
    }

    public static final class FieldMapExternalizer<T>
    extends FieldExternalizer.FieldConstructorExternalizer<T, Map<?, ?>>
    implements CollectionExternalizer<T, Map<?, ?>> {
        private final Externalizer<Object, ?> keyExternalizer = this.getGeneric(0);
        private final Externalizer<Object, ?> valueExternalizer = this.getGeneric(1);

        private FieldMapExternalizer(Field field, Class<? extends Map<?, ?>> clazz) {
            super(field, CollectionExternalizer.collectionClass(clazz));
        }

        @Override
        protected final void writeValue(Map<?, ?> map, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeInt(map.size());
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                this.keyExternalizer.writeExternal(entry.getKey(), out);
                this.valueExternalizer.writeExternal(entry.getValue(), out);
            }
        }

        @Override
        public final Map<?, ?> readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            if (!in.readBoolean()) {
                return null;
            }
            Map map = (Map)this.constructor.newInstance(new Object[0]);
            int size = in.readInt();
            while (size-- > 0) {
                map.put(this.keyExternalizer.readObject(in), this.valueExternalizer.readObject(in));
            }
            return map;
        }
    }

    public static final class FieldCollectionExternalizer<T>
    extends FieldExternalizer.FieldConstructorExternalizer<T, Collection<?>>
    implements CollectionExternalizer<T, Collection<?>> {
        protected final Externalizer<Object, ?> componentExternalizer = this.getGeneric(0);

        protected FieldCollectionExternalizer(Field field, Class<? extends Collection<?>> clazz) {
            super(field, CollectionExternalizer.collectionClass(clazz));
        }

        @Override
        protected final void writeValue(Collection<?> collection, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeInt(collection.size());
            for (Object o : collection) {
                this.componentExternalizer.writeExternal(o, out);
            }
        }

        @Override
        public final Collection readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            if (!in.readBoolean()) {
                return null;
            }
            Collection collection = (Collection)this.constructor.newInstance(new Object[0]);
            int size = in.readInt();
            while (size-- > 0) {
                collection.add(this.componentExternalizer.readObject(in));
            }
            return collection;
        }
    }

    public static final class FieldCollectionBooleanExternalizer<T>
    extends FieldExternalizer.FieldConstructorExternalizer<T, Collection<Boolean>>
    implements CollectionExternalizer<T, Collection<Boolean>> {
        protected FieldCollectionBooleanExternalizer(Field field, Class<? extends Collection<Boolean>> clazz) {
            super(field, clazz);
        }

        @Override
        protected final void writeValue(Collection<Boolean> collection, ObjectOutput out) throws IOException, ReflectiveOperationException {
            RoaringBitmap nullBitmap = new RoaringBitmap();
            RoaringBitmap booleanBitmap = new RoaringBitmap();
            int i = 0;
            for (Boolean value : collection) {
                if (value != null) {
                    if (value.booleanValue()) {
                        booleanBitmap.add(i);
                    }
                } else {
                    nullBitmap.add(i);
                }
                ++i;
            }
            out.writeInt(collection.size());
            nullBitmap.writeExternal(out);
            booleanBitmap.writeExternal(out);
        }

        @Override
        public final Collection<Boolean> readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            if (!in.readBoolean()) {
                return null;
            }
            Collection collection = (Collection)this.constructor.newInstance(new Object[0]);
            boolean[] array = new boolean[in.readInt()];
            RoaringBitmap nullBitmap = new RoaringBitmap();
            RoaringBitmap booleanBitmap = new RoaringBitmap();
            nullBitmap.readExternal(in);
            booleanBitmap.readExternal(in);
            for (int i = 0; i < array.length; ++i) {
                if (nullBitmap.contains(i)) {
                    collection.add(null);
                    continue;
                }
                collection.add(booleanBitmap.contains(i));
            }
            return collection;
        }
    }

    public static final class FieldCollectionByteExternalizer<T>
    extends FieldCollectionSnappyExternalizer<T, Byte> {
        protected FieldCollectionByteExternalizer(Field field, Class<? extends Collection<Byte>> clazz) {
            super(field, clazz);
        }

        @Override
        protected FieldCollectionSnappyExternalizer.NullableArray getNullableArray(int size) {
            return new ByteNullableArray(size);
        }

        @Override
        protected final void fillCollection(ObjectInput in, RoaringBitmap nullBitmap, Collection<Byte> collection) throws IOException {
            byte[] array = Snappy.uncompress(ArrayExternalizer.readBytes(in));
            int i = 0;
            for (byte value : array) {
                collection.add(nullBitmap.contains(i++) ? null : Byte.valueOf(value));
            }
        }

        private final class ByteNullableArray
        implements FieldCollectionSnappyExternalizer.NullableArray<Byte> {
            final byte[] array;

            private ByteNullableArray(int size) {
                this.array = new byte[size];
            }

            @Override
            public final void set(int i, Byte value) {
                this.array[i] = value;
            }

            @Override
            public final byte[] compress() throws IOException {
                return Snappy.compress(this.array);
            }
        }
    }

    public static final class FieldCollectionCharacterExternalizer<T>
    extends FieldCollectionSnappyExternalizer<T, Character> {
        protected FieldCollectionCharacterExternalizer(Field field, Class<? extends Collection<Character>> clazz) {
            super(field, clazz);
        }

        @Override
        protected FieldCollectionSnappyExternalizer.NullableArray getNullableArray(int size) {
            return new CharacterNullableArray(size);
        }

        @Override
        protected final void fillCollection(ObjectInput in, RoaringBitmap nullBitmap, Collection<Character> collection) throws IOException {
            char[] array = Snappy.uncompressCharArray(ArrayExternalizer.readBytes(in));
            int i = 0;
            for (char value : array) {
                collection.add(nullBitmap.contains(i++) ? null : Character.valueOf(value));
            }
        }

        private final class CharacterNullableArray
        implements FieldCollectionSnappyExternalizer.NullableArray<Character> {
            final char[] array;

            private CharacterNullableArray(int size) {
                this.array = new char[size];
            }

            @Override
            public final void set(int i, Character value) {
                this.array[i] = value.charValue();
            }

            @Override
            public final byte[] compress() throws IOException {
                return Snappy.compress(this.array);
            }
        }
    }

    public static final class FieldCollectionFloatExternalizer<T>
    extends FieldCollectionSnappyExternalizer<T, Float> {
        protected FieldCollectionFloatExternalizer(Field field, Class<? extends Collection<Float>> clazz) {
            super(field, clazz);
        }

        @Override
        protected FieldCollectionSnappyExternalizer.NullableArray getNullableArray(int size) {
            return new FloatNullableArray(size);
        }

        @Override
        protected final void fillCollection(ObjectInput in, RoaringBitmap nullBitmap, Collection<Float> collection) throws IOException {
            float[] array = Snappy.uncompressFloatArray(ArrayExternalizer.readBytes(in));
            int i = 0;
            for (float value : array) {
                collection.add(nullBitmap.contains(i++) ? null : Float.valueOf(value));
            }
        }

        private final class FloatNullableArray
        implements FieldCollectionSnappyExternalizer.NullableArray<Float> {
            final float[] array;

            private FloatNullableArray(int size) {
                this.array = new float[size];
            }

            @Override
            public final void set(int i, Float value) {
                this.array[i] = value.floatValue();
            }

            @Override
            public final byte[] compress() throws IOException {
                return Snappy.compress(this.array);
            }
        }
    }

    public static final class FieldCollectionDoubleExternalizer<T>
    extends FieldCollectionSnappyExternalizer<T, Double> {
        protected FieldCollectionDoubleExternalizer(Field field, Class<? extends Collection<Double>> clazz) {
            super(field, clazz);
        }

        @Override
        protected FieldCollectionSnappyExternalizer.NullableArray getNullableArray(int size) {
            return new DoubleNullableArray(size);
        }

        @Override
        protected final void fillCollection(ObjectInput in, RoaringBitmap nullBitmap, Collection<Double> collection) throws IOException {
            double[] array = Snappy.uncompressDoubleArray(ArrayExternalizer.readBytes(in));
            int i = 0;
            for (double value : array) {
                collection.add(nullBitmap.contains(i++) ? null : Double.valueOf(value));
            }
        }

        private final class DoubleNullableArray
        implements FieldCollectionSnappyExternalizer.NullableArray<Double> {
            final double[] array;

            private DoubleNullableArray(int size) {
                this.array = new double[size];
            }

            @Override
            public final void set(int i, Double value) {
                this.array[i] = value;
            }

            @Override
            public final byte[] compress() throws IOException {
                return Snappy.compress(this.array);
            }
        }
    }

    public static final class FieldCollectionShortExternalizer<T>
    extends FieldCollectionSnappyExternalizer<T, Short> {
        protected FieldCollectionShortExternalizer(Field field, Class<? extends Collection<Short>> clazz) {
            super(field, clazz);
        }

        @Override
        protected FieldCollectionSnappyExternalizer.NullableArray getNullableArray(int size) {
            return new ShortNullableArray(size);
        }

        @Override
        protected final void fillCollection(ObjectInput in, RoaringBitmap nullBitmap, Collection<Short> collection) throws IOException {
            short[] array = Snappy.uncompressShortArray(ArrayExternalizer.readBytes(in));
            int i = 0;
            for (short value : array) {
                collection.add(nullBitmap.contains(i++) ? null : Short.valueOf(value));
            }
        }

        private final class ShortNullableArray
        implements FieldCollectionSnappyExternalizer.NullableArray<Short> {
            final short[] array;

            private ShortNullableArray(int size) {
                this.array = new short[size];
            }

            @Override
            public final void set(int i, Short value) {
                this.array[i] = value;
            }

            @Override
            public final byte[] compress() throws IOException {
                return Snappy.compress(this.array);
            }
        }
    }

    public static final class FieldCollectionIntegerExternalizer<T>
    extends FieldCollectionSnappyExternalizer<T, Integer> {
        protected FieldCollectionIntegerExternalizer(Field field, Class<? extends Collection<Integer>> clazz) {
            super(field, clazz);
        }

        @Override
        protected FieldCollectionSnappyExternalizer.NullableArray getNullableArray(int size) {
            return new IntegerNullableArray(size);
        }

        @Override
        protected final void fillCollection(ObjectInput in, RoaringBitmap nullBitmap, Collection<Integer> collection) throws IOException {
            int[] array = Snappy.uncompressIntArray(ArrayExternalizer.readBytes(in));
            int i = 0;
            for (int value : array) {
                collection.add(nullBitmap.contains(i++) ? null : Integer.valueOf(value));
            }
        }

        private final class IntegerNullableArray
        implements FieldCollectionSnappyExternalizer.NullableArray<Integer> {
            final int[] array;

            private IntegerNullableArray(int size) {
                this.array = new int[size];
            }

            @Override
            public final void set(int i, Integer value) {
                this.array[i] = value;
            }

            @Override
            public final byte[] compress() throws IOException {
                return Snappy.compress(this.array);
            }
        }
    }

    public static final class FieldCollectionLongExternalizer<T>
    extends FieldCollectionSnappyExternalizer<T, Long> {
        protected FieldCollectionLongExternalizer(Field field, Class<? extends Collection<Long>> clazz) {
            super(field, clazz);
        }

        @Override
        protected FieldCollectionSnappyExternalizer.NullableArray getNullableArray(int size) {
            return new LongNullableArray(size);
        }

        @Override
        protected final void fillCollection(ObjectInput in, RoaringBitmap nullBitmap, Collection<Long> collection) throws IOException {
            long[] array = Snappy.uncompressLongArray(ArrayExternalizer.readBytes(in));
            int i = 0;
            for (long value : array) {
                collection.add(nullBitmap.contains(i++) ? null : Long.valueOf(value));
            }
        }

        private final class LongNullableArray
        implements FieldCollectionSnappyExternalizer.NullableArray<Long> {
            final long[] array;

            private LongNullableArray(int size) {
                this.array = new long[size];
            }

            @Override
            public final void set(int i, Long value) {
                this.array[i] = value;
            }

            @Override
            public final byte[] compress() throws IOException {
                return Snappy.compress(this.array);
            }
        }
    }

    public static abstract class FieldCollectionSnappyExternalizer<T, V>
    extends FieldExternalizer.FieldConstructorExternalizer<T, Collection<V>>
    implements CollectionExternalizer<T, Collection<V>> {
        protected FieldCollectionSnappyExternalizer(Field field, Class<? extends Collection<V>> clazz) {
            super(field, CollectionExternalizer.collectionClass(clazz));
        }

        protected abstract NullableArray getNullableArray(int var1);

        @Override
        protected final void writeValue(Collection<V> collection, ObjectOutput out) throws IOException, ReflectiveOperationException {
            NullableArray array = this.getNullableArray(collection.size());
            RoaringBitmap nullBitmap = new RoaringBitmap();
            int i = 0;
            for (V value : collection) {
                if (value == null) {
                    nullBitmap.add(i);
                } else {
                    array.set(i, value);
                }
                ++i;
            }
            nullBitmap.writeExternal(out);
            ArrayExternalizer.writeBytes(array.compress(), out);
        }

        protected abstract void fillCollection(ObjectInput var1, RoaringBitmap var2, Collection<V> var3) throws IOException;

        @Override
        public final Collection<V> readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            if (!in.readBoolean()) {
                return null;
            }
            RoaringBitmap nullBitmap = new RoaringBitmap();
            nullBitmap.readExternal(in);
            Collection collection = (Collection)this.constructor.newInstance(new Object[0]);
            this.fillCollection(in, nullBitmap, collection);
            return collection;
        }

        protected static interface NullableArray<V> {
            public void set(int var1, V var2);

            public byte[] compress() throws IOException;
        }
    }
}

