/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.externalizor;

import com.qwazr.externalizor.ArrayExternalizer;
import com.qwazr.externalizor.ClassExternalizer;
import com.qwazr.externalizor.CollectionExternalizer;
import com.qwazr.externalizor.FieldExternalizer;
import com.qwazr.externalizor.LangExternalizer;
import com.qwazr.externalizor.PrimitiveExternalizer;
import com.qwazr.externalizor.TimeExternalizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;

interface Externalizer<T, V> {
    public static <T, V> Externalizer<T, V> of(Class<? extends T> clazz) {
        Externalizer externalizer = LangExternalizer.lang(clazz);
        if (externalizer != null) {
            return externalizer;
        }
        externalizer = TimeExternalizer.time(clazz);
        if (externalizer != null) {
            return externalizer;
        }
        return ClassExternalizer.of(clazz);
    }

    public static <T, V> Externalizer<T, V> of(Field field, Class<? extends T> clazz) {
        Externalizer externalizer;
        if (clazz.isPrimitive() && (externalizer = PrimitiveExternalizer.primitive(field, clazz)) != null) {
            return externalizer;
        }
        if (clazz.isArray() && (externalizer = ArrayExternalizer.array(field, clazz)) != null) {
            return externalizer;
        }
        externalizer = CollectionExternalizer.collection(field, clazz);
        if (externalizer != null) {
            return externalizer;
        }
        externalizer = LangExternalizer.lang(field, clazz);
        if (externalizer != null) {
            return externalizer;
        }
        externalizer = TimeExternalizer.time(field, clazz);
        if (externalizer != null) {
            return externalizer;
        }
        return new FieldExternalizer.FieldParentExternalizer(field, ClassExternalizer.of(clazz));
    }

    public void writeExternal(T var1, ObjectOutput var2) throws IOException, ReflectiveOperationException;

    public void readExternal(T var1, ObjectInput var2) throws IOException, ReflectiveOperationException;

    public V readObject(ObjectInput var1) throws IOException, ReflectiveOperationException;
}

