/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.externalizor;

import com.qwazr.externalizor.Externalizer;
import com.qwazr.externalizor.ExternalizorException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;

abstract class FieldExternalizer<T, V>
implements Externalizer<T, V> {
    protected final Field field;

    protected FieldExternalizer(Field field) {
        this.field = field;
    }

    static final Class<?> getGenericClass(Field field, int pos) {
        ParameterizedType paramTypes = (ParameterizedType)field.getGenericType();
        return (Class)paramTypes.getActualTypeArguments()[pos];
    }

    static abstract class FieldConstructorExternalizer<T, C>
    extends FieldObjectExternalizer<T, C> {
        protected final Constructor<? extends C> constructor;

        protected FieldConstructorExternalizer(Field field, Class<? extends C> clazz) {
            super(field);
            try {
                this.constructor = clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ExternalizorException("Not empty public constructor for the type " + clazz);
            }
        }

        protected final Externalizer<Object, ?> getGeneric(int pos) {
            return Externalizer.of(FieldConstructorExternalizer.getGenericClass(this.field, pos));
        }
    }

    static class FieldParentExternalizer<T, V>
    extends FieldObjectExternalizer<T, V> {
        private final Externalizer<V, V> externalizer;

        protected FieldParentExternalizer(Field field, Externalizer<V, V> externalizer) {
            super(field);
            this.externalizer = externalizer;
        }

        @Override
        public final V readObject(ObjectInput in) throws IOException, ReflectiveOperationException {
            return in.readBoolean() ? (V)this.externalizer.readObject(in) : null;
        }

        @Override
        protected final void writeValue(V value, ObjectOutput out) throws IOException, ReflectiveOperationException {
            this.externalizer.writeExternal(value, out);
        }
    }

    static abstract class FieldObjectExternalizer<T, V>
    extends FieldExternalizer<T, V> {
        protected FieldObjectExternalizer(Field field) {
            super(field);
        }

        protected abstract void writeValue(V var1, ObjectOutput var2) throws IOException, ReflectiveOperationException;

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            this.field.set(object, this.readObject(in));
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            Object value = this.field.get(object);
            if (value == null) {
                out.writeBoolean(false);
                return;
            }
            out.writeBoolean(true);
            this.writeValue(value, out);
        }
    }
}

