/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.externalizor;

import com.qwazr.externalizor.Externalizer;
import com.qwazr.externalizor.ExternalizorException;
import com.qwazr.externalizor.FieldExternalizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;

interface LangExternalizer<T, V>
extends Externalizer<T, V> {
    public static <T, V> LangExternalizer<T, V> lang(Class<? extends T> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return StringExternalizer.INSTANCE;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return LongExternalizer.INSTANCE;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return IntegerExternalizer.INSTANCE;
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return ShortExternalizer.INSTANCE;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return DoubleExternalizer.INSTANCE;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return FloatExternalizer.INSTANCE;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return CharExternalizer.INSTANCE;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return ByteExternalizer.INSTANCE;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return BooleanExternalizer.INSTANCE;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return EnumExternalizer.get(clazz);
        }
        return null;
    }

    public static <T, V> FieldExternalizer<T, V> lang(Field field, Class<? extends T> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, StringExternalizer.INSTANCE);
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, LongExternalizer.INSTANCE);
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, IntegerExternalizer.INSTANCE);
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, ShortExternalizer.INSTANCE);
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, DoubleExternalizer.INSTANCE);
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, FloatExternalizer.INSTANCE);
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, CharExternalizer.INSTANCE);
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, ByteExternalizer.INSTANCE);
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, BooleanExternalizer.INSTANCE);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, EnumExternalizer.get(clazz));
        }
        return null;
    }

    @Override
    default public void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
        throw new ExternalizorException("Not available");
    }

    public static final class EnumExternalizer
    implements LangExternalizer<Enum<?>, Enum<?>> {
        private static final ConcurrentHashMap<Class<? extends Enum<?>>, EnumExternalizer> externalizers = new ConcurrentHashMap();
        private final Class<? extends Enum> enumType;

        private static final EnumExternalizer get(Class<? extends Enum<?>> enumType) {
            return externalizers.computeIfAbsent(enumType, EnumExternalizer::new);
        }

        private EnumExternalizer(Class<? extends Enum<?>> enumType) {
            this.enumType = enumType;
        }

        @Override
        public final void writeExternal(Enum<?> object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeUTF(object.name());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Enum<?> readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Enum.valueOf(this.enumType, in.readUTF()) : null;
        }
    }

    public static final class BooleanExternalizer
    implements LangExternalizer<Boolean, Boolean> {
        static final BooleanExternalizer INSTANCE = new BooleanExternalizer();

        @Override
        public final void writeExternal(Boolean object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeBoolean(object);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Boolean readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Boolean.valueOf(in.readBoolean()) : null;
        }
    }

    public static final class CharExternalizer
    implements LangExternalizer<Character, Character> {
        static final CharExternalizer INSTANCE = new CharExternalizer();

        @Override
        public final void writeExternal(Character object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeChar(object.charValue());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Character readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Character.valueOf(in.readChar()) : null;
        }
    }

    public static final class ByteExternalizer
    implements LangExternalizer<Byte, Byte> {
        static final ByteExternalizer INSTANCE = new ByteExternalizer();

        @Override
        public final void writeExternal(Byte object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeByte(object.byteValue());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Byte readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Byte.valueOf(in.readByte()) : null;
        }
    }

    public static final class FloatExternalizer
    implements LangExternalizer<Float, Float> {
        static final FloatExternalizer INSTANCE = new FloatExternalizer();

        @Override
        public final void writeExternal(Float object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeFloat(object.floatValue());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Float readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Float.valueOf(in.readFloat()) : null;
        }
    }

    public static final class DoubleExternalizer
    implements LangExternalizer<Double, Double> {
        static final DoubleExternalizer INSTANCE = new DoubleExternalizer();

        @Override
        public final void writeExternal(Double object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeDouble(object);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Double readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Double.valueOf(in.readDouble()) : null;
        }
    }

    public static final class ShortExternalizer
    implements LangExternalizer<Short, Short> {
        static final ShortExternalizer INSTANCE = new ShortExternalizer();

        @Override
        public final void writeExternal(Short object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeShort(object.shortValue());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Short readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Short.valueOf(in.readShort()) : null;
        }
    }

    public static final class IntegerExternalizer
    implements LangExternalizer<Integer, Integer> {
        static final IntegerExternalizer INSTANCE = new IntegerExternalizer();

        @Override
        public final void writeExternal(Integer object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeInt(object);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Integer readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Integer.valueOf(in.readInt()) : null;
        }
    }

    public static final class LongExternalizer
    implements LangExternalizer<Long, Long> {
        static final LongExternalizer INSTANCE = new LongExternalizer();

        @Override
        public final void writeExternal(Long object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeLong(object);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Long readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Long.valueOf(in.readLong()) : null;
        }
    }

    public static final class StringExternalizer
    implements LangExternalizer<String, String> {
        static final StringExternalizer INSTANCE = new StringExternalizer();

        @Override
        public final void writeExternal(String object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeUTF(object);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final String readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? in.readUTF() : null;
        }
    }
}

