/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.externalizor;

import com.qwazr.externalizor.Externalizer;
import com.qwazr.externalizor.ExternalizorException;
import com.qwazr.externalizor.FieldExternalizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;

interface PrimitiveExternalizer<T, V>
extends Externalizer<T, V> {
    public static <T, V> PrimitiveExternalizer<T, V> primitive(Field field, Class<T> clazz) {
        if (Integer.TYPE.equals(clazz)) {
            return new FieldIntegerExternalizer(field);
        }
        if (Short.TYPE.equals(clazz)) {
            return new FieldShortExternalizer(field);
        }
        if (Long.TYPE.equals(clazz)) {
            return new FieldLongExternalizer(field);
        }
        if (Float.TYPE.equals(clazz)) {
            return new FieldFloatExternalizer(field);
        }
        if (Double.TYPE.equals(clazz)) {
            return new FieldDoubleExternalizer(field);
        }
        if (Boolean.TYPE.equals(clazz)) {
            return new FieldBooleanExternalizer(field);
        }
        if (Byte.TYPE.equals(clazz)) {
            return new FieldByteExternalizer(field);
        }
        if (Character.TYPE.equals(clazz)) {
            return new FieldCharExternalizer(field);
        }
        return null;
    }

    public static final class FieldBooleanExternalizer<T>
    extends FieldPrimitiveExternalizer<T, Boolean> {
        private FieldBooleanExternalizer(Field field) {
            super(field);
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeBoolean(this.field.getBoolean(object));
        }

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            this.field.setBoolean(object, in.readBoolean());
        }
    }

    public static final class FieldCharExternalizer<T>
    extends FieldPrimitiveExternalizer<T, Character> {
        private FieldCharExternalizer(Field field) {
            super(field);
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeChar(this.field.getChar(object));
        }

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            this.field.setChar(object, in.readChar());
        }
    }

    public static final class FieldByteExternalizer<T>
    extends FieldPrimitiveExternalizer<T, Byte> {
        private FieldByteExternalizer(Field field) {
            super(field);
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeByte(this.field.getByte(object));
        }

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            this.field.setByte(object, in.readByte());
        }
    }

    public static final class FieldDoubleExternalizer<T>
    extends FieldPrimitiveExternalizer<T, Double> {
        private FieldDoubleExternalizer(Field field) {
            super(field);
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeDouble(this.field.getDouble(object));
        }

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            this.field.setDouble(object, in.readDouble());
        }
    }

    public static final class FieldFloatExternalizer<T>
    extends FieldPrimitiveExternalizer<T, Float> {
        private FieldFloatExternalizer(Field field) {
            super(field);
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeFloat(this.field.getFloat(object));
        }

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            this.field.setFloat(object, in.readFloat());
        }
    }

    public static final class FieldShortExternalizer<T>
    extends FieldPrimitiveExternalizer<T, Short> {
        private FieldShortExternalizer(Field field) {
            super(field);
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeShort(this.field.getShort(object));
        }

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            this.field.setShort(object, in.readShort());
        }
    }

    public static final class FieldLongExternalizer<T>
    extends FieldPrimitiveExternalizer<T, Long> {
        private FieldLongExternalizer(Field field) {
            super(field);
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeLong(this.field.getLong(object));
        }

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            this.field.setLong(object, in.readLong());
        }
    }

    public static final class FieldIntegerExternalizer<T>
    extends FieldPrimitiveExternalizer<T, Integer> {
        private FieldIntegerExternalizer(Field field) {
            super(field);
        }

        @Override
        public final void writeExternal(T object, ObjectOutput out) throws IOException, ReflectiveOperationException {
            out.writeInt(this.field.getInt(object));
        }

        @Override
        public final void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
            this.field.setInt(object, in.readInt());
        }
    }

    public static abstract class FieldPrimitiveExternalizer<T, V>
    extends FieldExternalizer<T, V>
    implements PrimitiveExternalizer<T, V> {
        protected FieldPrimitiveExternalizer(Field field) {
            super(field);
        }

        @Override
        public final V readObject(ObjectInput in) throws IOException {
            throw new ExternalizorException("Not available for primitive types");
        }
    }
}

