/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.externalizor;

import com.qwazr.externalizor.Externalizer;
import com.qwazr.externalizor.ExternalizorException;
import com.qwazr.externalizor.FieldExternalizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Period;
import java.time.Year;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;

interface TimeExternalizer<T, V>
extends Externalizer<T, V> {
    public static <T, V> Externalizer<T, V> time(Class<? extends T> clazz) {
        if (Calendar.class.isAssignableFrom(clazz)) {
            return CalendarExternalizer.INSTANCE;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DateExternalizer.INSTANCE;
        }
        if (Duration.class.isAssignableFrom(clazz)) {
            return DurationExternalizer.INSTANCE;
        }
        if (Instant.class.isAssignableFrom(clazz)) {
            return InstantExternalizer.INSTANCE;
        }
        if (LocalDate.class.isAssignableFrom(clazz)) {
            return LocalDateExternalizer.INSTANCE;
        }
        if (LocalDateTime.class.isAssignableFrom(clazz)) {
            return LocalDateTimeExternalizer.INSTANCE;
        }
        if (LocalTime.class.isAssignableFrom(clazz)) {
            return LocalTimeExternalizer.INSTANCE;
        }
        if (MonthDay.class.isAssignableFrom(clazz)) {
            return MonthDayExternalizer.INSTANCE;
        }
        if (Period.class.isAssignableFrom(clazz)) {
            return PeriodExternalizer.INSTANCE;
        }
        if (Year.class.isAssignableFrom(clazz)) {
            return YearExternalizer.INSTANCE;
        }
        return null;
    }

    public static <T, V> Externalizer<T, V> time(Field field, Class<? extends T> clazz) {
        if (Calendar.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, CalendarExternalizer.INSTANCE);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, DateExternalizer.INSTANCE);
        }
        if (Duration.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, DurationExternalizer.INSTANCE);
        }
        if (Instant.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, InstantExternalizer.INSTANCE);
        }
        if (LocalDate.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, LocalDateExternalizer.INSTANCE);
        }
        if (LocalDateTime.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, LocalDateTimeExternalizer.INSTANCE);
        }
        if (LocalTime.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, LocalTimeExternalizer.INSTANCE);
        }
        if (MonthDay.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, MonthDayExternalizer.INSTANCE);
        }
        if (Period.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, PeriodExternalizer.INSTANCE);
        }
        if (Year.class.isAssignableFrom(clazz)) {
            return new FieldExternalizer.FieldParentExternalizer(field, YearExternalizer.INSTANCE);
        }
        return null;
    }

    @Override
    default public void readExternal(T object, ObjectInput in) throws IOException, ReflectiveOperationException {
        throw new ExternalizorException("Not available");
    }

    public static final class YearExternalizer
    implements TimeExternalizer<Year, Year> {
        static final YearExternalizer INSTANCE = new YearExternalizer();

        @Override
        public final void writeExternal(Year object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeInt(object.getValue());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Year readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Year.of(in.readInt()) : null;
        }
    }

    public static final class PeriodExternalizer
    implements TimeExternalizer<Period, Period> {
        static final PeriodExternalizer INSTANCE = new PeriodExternalizer();

        @Override
        public final void writeExternal(Period object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeInt(object.getYears());
                out.writeInt(object.getMonths());
                out.writeInt(object.getDays());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Period readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Period.of(in.readInt(), in.readInt(), in.readInt()) : null;
        }
    }

    public static final class MonthDayExternalizer
    implements TimeExternalizer<MonthDay, MonthDay> {
        static final MonthDayExternalizer INSTANCE = new MonthDayExternalizer();

        @Override
        public final void writeExternal(MonthDay object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeByte(object.getMonthValue());
                out.writeByte(object.getDayOfMonth());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final MonthDay readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? MonthDay.of(in.readByte(), (int)in.readByte()) : null;
        }
    }

    public static final class LocalTimeExternalizer
    implements TimeExternalizer<LocalTime, LocalTime> {
        static final LocalTimeExternalizer INSTANCE = new LocalTimeExternalizer();

        @Override
        public final void writeExternal(LocalTime object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeLong(object.toNanoOfDay());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final LocalTime readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? LocalTime.ofNanoOfDay(in.readLong()) : null;
        }
    }

    public static final class LocalDateTimeExternalizer
    implements TimeExternalizer<LocalDateTime, LocalDateTime> {
        static final LocalDateTimeExternalizer INSTANCE = new LocalDateTimeExternalizer();

        @Override
        public final void writeExternal(LocalDateTime object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeLong(object.toLocalDate().getLong(ChronoField.EPOCH_DAY));
                out.writeLong(object.toLocalTime().toNanoOfDay());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final LocalDateTime readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? LocalDateTime.of(LocalDate.ofEpochDay(in.readLong()), LocalTime.ofNanoOfDay(in.readLong())) : null;
        }
    }

    public static final class LocalDateExternalizer
    implements TimeExternalizer<LocalDate, LocalDate> {
        static final LocalDateExternalizer INSTANCE = new LocalDateExternalizer();

        @Override
        public final void writeExternal(LocalDate object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeLong(object.getLong(ChronoField.EPOCH_DAY));
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final LocalDate readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? LocalDate.ofEpochDay(in.readLong()) : null;
        }
    }

    public static final class InstantExternalizer
    implements TimeExternalizer<Instant, Instant> {
        static final InstantExternalizer INSTANCE = new InstantExternalizer();

        @Override
        public final void writeExternal(Instant object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeLong(object.getEpochSecond());
                out.writeInt(object.getNano());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Instant readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Instant.ofEpochSecond(in.readLong(), in.readInt()) : null;
        }
    }

    public static final class DurationExternalizer
    implements TimeExternalizer<Duration, Duration> {
        static final DurationExternalizer INSTANCE = new DurationExternalizer();

        @Override
        public final void writeExternal(Duration object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeLong(object.getSeconds());
                out.writeInt(object.getNano());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Duration readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? Duration.ofSeconds(in.readLong(), in.readInt()) : null;
        }
    }

    public static final class CalendarExternalizer
    implements TimeExternalizer<Calendar, Calendar> {
        static final CalendarExternalizer INSTANCE = new CalendarExternalizer();

        @Override
        public final void writeExternal(Calendar object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeLong(object.getTimeInMillis());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Calendar readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            if (!in.readBoolean()) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(in.readLong());
            return cal;
        }
    }

    public static final class DateExternalizer
    implements TimeExternalizer<Date, Date> {
        static final DateExternalizer INSTANCE = new DateExternalizer();

        @Override
        public final void writeExternal(Date object, ObjectOutput out) throws IOException {
            if (object != null) {
                out.writeBoolean(true);
                out.writeLong(object.getTime());
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public final Date readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readBoolean() ? new Date(in.readLong()) : null;
        }
    }
}

