/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.qwazr.database.store.Table;
import com.qwazr.database.store.Tables;
import com.qwazr.graph.GraphInstance;
import com.qwazr.graph.GraphServiceImpl;
import com.qwazr.graph.GraphServiceInterface;
import com.qwazr.graph.model.GraphDefinition;
import com.qwazr.server.GenericServer;
import com.qwazr.server.ServerException;
import com.qwazr.utils.FileUtils;
import com.qwazr.utils.LockUtils;
import com.qwazr.utils.json.DirectoryJsonManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;

public class GraphManager
extends DirectoryJsonManager<GraphDefinition> {
    private final LockUtils.ReadWriteLock rwl = new LockUtils.ReadWriteLock();
    private final GraphServiceInterface service;
    private final Map<String, GraphInstance> graphMap = new HashMap<String, GraphInstance>();

    public GraphManager(GenericServer.Builder builder) throws ServerException, IOException {
        super(FileUtils.createDirectory(new File(builder.getConfiguration().dataDirectory, "graph")), GraphDefinition.class);
        for (String name : this.nameSet()) {
            this.addNewInstance(name, this.get(name));
        }
        if (builder != null) {
            builder.webService(GraphServiceImpl.class);
            builder.contextAttribute(this);
        }
        this.service = new GraphServiceImpl(this);
    }

    public GraphServiceInterface getService() {
        return this.service;
    }

    private GraphInstance addNewInstance(String graphName, GraphDefinition graphDef) throws IOException, ServerException {
        File dbDirectory = new File(this.directory, graphName);
        if (!dbDirectory.exists()) {
            dbDirectory.mkdir();
        }
        Table table = Tables.getInstance(dbDirectory, graphDef.implementation);
        GraphInstance graphInstance = new GraphInstance(graphName, table, graphDef);
        graphInstance.checkFields();
        this.graphMap.put(graphName, graphInstance);
        return graphInstance;
    }

    public GraphInstance getGraphInstance(String graphName) throws ServerException {
        return this.rwl.readEx(() -> {
            GraphInstance graphInstance = this.graphMap.get(graphName);
            if (graphInstance == null) {
                throw new ServerException(Response.Status.NOT_FOUND, "Graph instance not found");
            }
            return graphInstance;
        });
    }

    @Override
    public Set<String> nameSet() {
        return super.nameSet();
    }

    @Override
    public GraphDefinition get(String name) throws IOException {
        return (GraphDefinition)super.get(name);
    }

    public void createUpdateGraph(String graphName, GraphDefinition graphDef) throws IOException, ServerException {
        this.rwl.writeEx(() -> {
            super.set(graphName, graphDef);
            this.graphMap.remove(graphName);
            this.addNewInstance(graphName, graphDef);
        });
    }

    @Override
    public GraphDefinition delete(String graphName) throws ServerException, IOException {
        return this.rwl.writeEx(() -> {
            GraphDefinition graphDef = (GraphDefinition)super.delete(graphName);
            File dbDirectory = new File(this.directory, graphName);
            Tables.delete(dbDirectory);
            FileUtils.deleteDirectory(dbDirectory);
            this.graphMap.remove(graphName);
            return graphDef;
        });
    }
}

