/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.qwazr.graph.GraphServiceInterface;
import com.qwazr.graph.GraphSingleClient;
import com.qwazr.graph.model.GraphDefinition;
import com.qwazr.graph.model.GraphNode;
import com.qwazr.graph.model.GraphNodeResult;
import com.qwazr.graph.model.GraphRequest;
import com.qwazr.graph.model.GraphResult;
import com.qwazr.server.RemoteService;
import com.qwazr.server.ServerException;
import com.qwazr.server.client.JsonMultiClientAbstract;
import com.qwazr.utils.ExceptionUtils;
import com.qwazr.utils.concurrent.ThreadUtils;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMultiClient
extends JsonMultiClientAbstract<GraphSingleClient>
implements GraphServiceInterface {
    private static final Logger logger = LoggerFactory.getLogger(GraphMultiClient.class);

    GraphMultiClient(RemoteService ... remote) throws URISyntaxException {
        super(new GraphSingleClient[remote.length], remote);
    }

    @Override
    public Set<String> list() {
        try {
            TreeSet<String> globalSet = new TreeSet<String>();
            ArrayList threads = new ArrayList(this.size());
            this.forEach(client -> threads.add(() -> {
                Set<String> set = client.list();
                TreeSet treeSet = globalSet;
                synchronized (treeSet) {
                    if (set != null) {
                        globalSet.addAll(set);
                    }
                }
            }));
            ThreadUtils.parallel(threads);
            return globalSet;
        }
        catch (Exception e) {
            throw ServerException.getJsonException(logger, e);
        }
    }

    @Override
    public GraphDefinition createUpdateGraph(String graphName, GraphDefinition graphDef) {
        try {
            AtomicReference resultRef = new AtomicReference();
            ArrayList threads = new ArrayList(this.size());
            this.forEach(client -> threads.add(() -> resultRef.compareAndSet(null, client.createUpdateGraph(graphName, graphDef))));
            ThreadUtils.parallel(threads);
            return (GraphDefinition)resultRef.get();
        }
        catch (Exception e) {
            throw ServerException.getJsonException(logger, e);
        }
    }

    @Override
    public GraphResult getGraph(String graphName) {
        ExceptionUtils.Holder exceptionHolder = new ExceptionUtils.Holder(logger);
        for (GraphSingleClient client : this) {
            try {
                return client.getGraph(graphName);
            }
            catch (WebApplicationException e) {
                if (e.getResponse().getStatus() == 404) {
                    logger.warn(e.getMessage(), e);
                    continue;
                }
                exceptionHolder.switchAndWarn(e);
            }
        }
        exceptionHolder.thrownIfAny();
        return null;
    }

    @Override
    public GraphDefinition deleteGraph(String graphName) {
        try {
            AtomicReference resultRef = new AtomicReference();
            ArrayList threads = new ArrayList(this.size());
            this.forEach(client -> threads.add(() -> {
                block2: {
                    try {
                        resultRef.compareAndSet(null, client.deleteGraph(graphName));
                    }
                    catch (WebApplicationException e) {
                        if (e.getResponse().getStatus() == 404) break block2;
                        logger.warn(e.getMessage(), e);
                        throw e;
                    }
                }
            }));
            ThreadUtils.parallel(threads);
            GraphDefinition graphDef = (GraphDefinition)resultRef.get();
            if (graphDef == null) {
                throw new ServerException(Response.Status.NOT_FOUND, "Graph not found: " + graphName);
            }
            return graphDef;
        }
        catch (Exception e) {
            throw ServerException.getJsonException(logger, e);
        }
    }

    @Override
    public Set<String> createUpdateNodes(String db_name, LinkedHashMap<String, GraphNode> nodes, Boolean upsert) {
        return null;
    }

    @Override
    public Long createUpdateNodes(String db_name, Boolean upsert, InputStream inpustStream) {
        return null;
    }

    @Override
    public GraphNode createUpdateNode(String db_name, String node_id, GraphNode node, Boolean upsert) {
        return null;
    }

    @Override
    public GraphNode getNode(String db_name, String node_id) {
        return null;
    }

    @Override
    public GraphNode deleteNode(String db_name, String node_id) {
        return null;
    }

    @Override
    public GraphNode createEdge(String db_name, String node_id, String edge_type, String to_node_id) {
        return null;
    }

    @Override
    public GraphNode deleteEdge(String db_name, String node_id, String edge_type, String to_node_id) {
        return null;
    }

    @Override
    public List<GraphNodeResult> requestNodes(String db_name, GraphRequest request) {
        return null;
    }

    @Override
    protected GraphSingleClient newClient(RemoteService remote) {
        return new GraphSingleClient(remote);
    }
}

