/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.qwazr.cluster.ClusterManager;
import com.qwazr.graph.GraphManager;
import com.qwazr.graph.GraphServiceInterface;
import com.qwazr.server.BaseServer;
import com.qwazr.server.GenericServer;
import com.qwazr.server.WelcomeShutdownService;
import com.qwazr.server.configuration.ServerConfiguration;
import java.io.IOException;
import java.net.URISyntaxException;

public class GraphServer
implements BaseServer {
    private final GenericServer server;
    private final GraphManager graphManager;
    private static volatile GraphServer INSTANCE;

    private GraphServer(ServerConfiguration configuration) throws IOException, URISyntaxException {
        GenericServer.Builder builder = GenericServer.of(configuration, null);
        new ClusterManager(builder);
        this.graphManager = new GraphManager(builder);
        builder.webService(WelcomeShutdownService.class);
        this.server = builder.build();
    }

    @Override
    public GenericServer getServer() {
        return this.server;
    }

    public GraphServiceInterface getService() {
        return this.graphManager.getService();
    }

    public static GraphServer getInstance() {
        return INSTANCE;
    }

    public static synchronized void main(String ... args) throws Exception {
        GraphServer.shutdown();
        INSTANCE = new GraphServer(new ServerConfiguration(args));
        INSTANCE.start();
    }

    public static synchronized void shutdown() {
        if (INSTANCE == null) {
            return;
        }
        INSTANCE.stop();
        INSTANCE = null;
    }
}

