/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph;

import com.fasterxml.jackson.core.type.TypeReference;
import com.qwazr.graph.GraphServiceInterface;
import com.qwazr.graph.model.GraphDefinition;
import com.qwazr.graph.model.GraphNode;
import com.qwazr.graph.model.GraphNodeResult;
import com.qwazr.graph.model.GraphRequest;
import com.qwazr.graph.model.GraphResult;
import com.qwazr.server.RemoteService;
import com.qwazr.server.client.JsonClientAbstract;
import com.qwazr.utils.UBuilder;
import com.qwazr.utils.http.HttpRequest;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;

public class GraphSingleClient
extends JsonClientAbstract
implements GraphServiceInterface {
    private static final String GRAPH_PREFIX = "/graph/";
    public static final TypeReference<TreeSet<String>> SetStringTypeRef = new TypeReference<TreeSet<String>>(){};

    GraphSingleClient(RemoteService remote) {
        super(remote);
    }

    @Override
    public Set<String> list() {
        UBuilder uBuilder = RemoteService.getNewUBuilder(this.remote, GRAPH_PREFIX);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uBuilder.buildNoEx());
        return this.executeJson(request, null, null, SetStringTypeRef, valid200Json);
    }

    @Override
    public GraphResult createUpdateGraph(String graphName, GraphDefinition graphDef) {
        UBuilder uBuilder = RemoteService.getNewUBuilder(this.remote, GRAPH_PREFIX, graphName);
        HttpRequest.Entity<HttpPost> request = HttpRequest.Post(uBuilder.buildNoEx());
        return this.executeJson(request, (Object)graphDef, null, GraphResult.class, valid200Json);
    }

    @Override
    public GraphResult getGraph(String graphName) {
        UBuilder uBuilder = RemoteService.getNewUBuilder(this.remote, GRAPH_PREFIX, graphName);
        HttpRequest.Base<HttpGet> request = HttpRequest.Get(uBuilder.buildNoEx());
        return this.executeJson(request, null, null, GraphResult.class, valid200Json);
    }

    @Override
    public GraphResult deleteGraph(String graphName) {
        UBuilder uBuilder = RemoteService.getNewUBuilder(this.remote, GRAPH_PREFIX, graphName);
        HttpRequest.Base<HttpDelete> request = HttpRequest.Delete(uBuilder.buildNoEx());
        return this.executeJson(request, null, null, GraphResult.class, valid200Json);
    }

    @Override
    public Set<String> createUpdateNodes(String db_name, LinkedHashMap<String, GraphNode> nodes, Boolean upsert) {
        return null;
    }

    @Override
    public Long createUpdateNodes(String db_name, Boolean upsert, InputStream inpustStream) {
        return null;
    }

    @Override
    public GraphNode createUpdateNode(String db_name, String node_id, GraphNode node, Boolean upsert) {
        return null;
    }

    @Override
    public GraphNode getNode(String db_name, String node_id) {
        return null;
    }

    @Override
    public GraphNode deleteNode(String db_name, String node_id) {
        return null;
    }

    @Override
    public GraphNode createEdge(String db_name, String node_id, String edge_type, String to_node_id) {
        return null;
    }

    @Override
    public GraphNode deleteEdge(String db_name, String node_id, String edge_type, String to_node_id) {
        return null;
    }

    @Override
    public List<GraphNodeResult> requestNodes(String db_name, GraphRequest request) {
        return null;
    }
}

