/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.qwazr.database.store.KeyStore;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlTransient;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class GraphDefinition {
    public final KeyStore.Impl implementation;
    public final Map<String, PropertyTypeEnum> node_properties;
    public final Set<String> edge_types;

    public GraphDefinition() {
        this(null, null, null);
    }

    public GraphDefinition(KeyStore.Impl implementation, Map<String, PropertyTypeEnum> node_properties, Set<String> edge_types) {
        this.implementation = implementation;
        this.node_properties = node_properties;
        this.edge_types = edge_types;
    }

    protected GraphDefinition(GraphDefinition graphDef) {
        this.implementation = graphDef.implementation;
        this.node_properties = graphDef.node_properties;
        this.edge_types = graphDef.edge_types;
    }

    @XmlTransient
    @JsonIgnore
    public boolean isEdgeType(String edge_type) {
        return this.edge_types == null ? false : this.edge_types.contains(edge_type);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isIndexedProperty(String property) {
        if (this.node_properties == null) {
            return false;
        }
        PropertyTypeEnum type = this.node_properties.get(property);
        if (type == null) {
            return false;
        }
        return type == PropertyTypeEnum.indexed;
    }

    public static enum PropertyTypeEnum {
        indexed,
        stored,
        boost;

    }
}

