/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;

public abstract class AbstractStreamingOutput
implements StreamingOutput {
    public static final HttpResponseStreamingOutput with(CloseableHttpResponse response) {
        return new HttpResponseStreamingOutput(response);
    }

    public static final InputStreamingOutput with(InputStream input) {
        return new InputStreamingOutput(input);
    }

    public static final AbstractStreamingOutput with(Reader reader, Charset charset) {
        return new ReaderStreamingOutput(reader, charset);
    }

    public abstract InputStream getInputStream() throws IOException;

    public static class ReaderStreamingOutput
    extends InputStreamingOutput {
        private ReaderStreamingOutput(Reader reader, Charset charset) {
            super(new ReaderInputStream(reader, charset));
        }
    }

    public static class InputStreamingOutput
    extends AbstractStreamingOutput {
        protected final InputStream inputStream;

        private InputStreamingOutput(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        @Override
        public final InputStream getInputStream() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("The inputStream is null");
            }
            return this.inputStream;
        }

        @Override
        public final void write(OutputStream output) throws IOException {
            IOUtils.copy(this.getInputStream(), output);
            IOUtils.closeQuietly(this.inputStream);
        }
    }

    public static final class HttpResponseStreamingOutput
    extends AbstractStreamingOutput {
        private final CloseableHttpResponse response;

        private HttpResponseStreamingOutput(CloseableHttpResponse response) {
            this.response = response;
        }

        @Override
        public final InputStream getInputStream() throws IOException {
            try {
                if (this.response == null) {
                    throw new ClientProtocolException("The response is null");
                }
                HttpEntity entity = this.response.getEntity();
                if (entity == null) {
                    return null;
                }
                InputStream input = entity.getContent();
                if (input == null) {
                    throw new ClientProtocolException("The entity content is empty");
                }
                return input;
            }
            catch (ClientProtocolException e) {
                IOUtils.closeQuietly((Closeable)this.response);
                throw e;
            }
        }

        @Override
        public final void write(OutputStream output) throws IOException {
            IOUtils.copy(this.getInputStream(), output);
            IOUtils.closeQuietly((Closeable)this.response);
        }
    }
}

