/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import com.qwazr.server.ConnectorStatisticsMXBean;
import com.qwazr.server.LogMetricsHandler;
import com.qwazr.server.RestApplication;
import com.qwazr.server.SecurableServletInfo;
import com.qwazr.server.ServiceName;
import com.qwazr.server.ServletApplication;
import com.qwazr.server.UdpServerThread;
import com.qwazr.server.configuration.ServerConfiguration;
import com.qwazr.utils.AnnotationsUtils;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.HttpHandler;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenericServer {
    private final ExecutorService executorService;
    private final ServletContainer servletContainer;
    private final Map<String, Object> contextAttributes;
    private final Collection<Class<?>> webServices;
    private final Collection<String> webServiceNames;
    private final Collection<String> webServicePaths;
    private final IdentityManagerProvider identityManagerProvider;
    private final Collection<ConnectorStatisticsMXBean> connectorsStatistics;
    private final Collection<Listener> startedListeners;
    private final Collection<Listener> shutdownListeners;
    private final Collection<Undertow> undertows;
    private final Collection<DeploymentManager> deploymentManagers;
    private final ServerConfiguration configuration;
    private final Collection<SecurableServletInfo> servletInfos;
    private final Map<String, FilterInfo> filterInfos;
    private final Collection<ListenerInfo> listenerInfos;
    private final SessionPersistenceManager sessionPersistenceManager;
    private final SessionListener sessionListener;
    private final Logger servletAccessLogger;
    private final Logger restAccessLogger;
    private final UdpServerThread udpServer;
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericServer.class);

    private GenericServer(Builder builder) throws IOException {
        this.configuration = builder.configuration;
        this.executorService = builder.executorService == null ? Executors.newCachedThreadPool() : builder.executorService;
        this.servletContainer = Servlets.newContainer();
        builder.contextAttribute(this);
        this.contextAttributes = new LinkedHashMap<String, Object>(builder.contextAttributes);
        this.webServices = builder.webServices.isEmpty() ? null : new ArrayList(builder.webServices);
        this.webServiceNames = builder.webServiceNames.isEmpty() ? null : new ArrayList<String>(builder.webServiceNames);
        this.webServicePaths = builder.webServicePaths.isEmpty() ? null : new ArrayList<String>(builder.webServicePaths);
        this.undertows = new ArrayList<Undertow>();
        this.deploymentManagers = new ArrayList<DeploymentManager>();
        this.identityManagerProvider = builder.identityManagerProvider;
        this.servletInfos = builder.servletInfos.isEmpty() ? null : new ArrayList<SecurableServletInfo>(builder.servletInfos);
        this.filterInfos = builder.filterInfos.isEmpty() ? null : new LinkedHashMap<String, FilterInfo>(builder.filterInfos);
        this.listenerInfos = builder.listenerInfos.isEmpty() ? null : new ArrayList<ListenerInfo>(builder.listenerInfos);
        this.sessionPersistenceManager = builder.sessionPersistenceManager;
        this.sessionListener = builder.sessionListener;
        this.servletAccessLogger = builder.servletAccessLogger;
        this.restAccessLogger = builder.restAccessLogger;
        this.udpServer = GenericServer.buildUdpServer(builder, this.configuration);
        this.startedListeners = builder.startedListeners.isEmpty() ? null : new ArrayList<Listener>(builder.startedListeners);
        this.shutdownListeners = builder.shutdownListeners.isEmpty() ? null : new ArrayList<Listener>(builder.shutdownListeners);
        this.connectorsStatistics = new ArrayList<ConnectorStatisticsMXBean>();
    }

    public void forEachWebServices(Consumer<Class<?>> consumer) {
        if (this.webServices != null) {
            this.webServices.forEach(consumer::accept);
        }
    }

    public void forEachServicePath(Consumer<String> consumer) {
        if (this.webServicePaths != null) {
            this.webServicePaths.forEach(consumer::accept);
        }
    }

    public static <T> T getContextAttribute(ServletContext context, String name, Class<T> type) {
        Object object = context.getAttribute(name);
        if (object == null) {
            return null;
        }
        if (!object.getClass().isAssignableFrom(type)) {
            throw new RuntimeException("Wrong returned type: " + object.getClass().getName() + " - Expected: " + type.getName());
        }
        return (T)object;
    }

    public static <T> T getContextAttribute(ServletContext context, Class<T> cls) {
        return GenericServer.getContextAttribute(context, cls.getName(), cls);
    }

    public Collection<String> getWebServiceNames() {
        return this.webServiceNames;
    }

    private static UdpServerThread buildUdpServer(Builder builder, ServerConfiguration configuration) throws IOException {
        if (builder.packetListeners == null || builder.packetListeners.isEmpty()) {
            return null;
        }
        if (configuration.multicastConnector.address != null && configuration.multicastConnector.port != -1) {
            return new UdpServerThread(configuration.multicastConnector.address, configuration.multicastConnector.port, builder.packetListeners);
        }
        return new UdpServerThread(new InetSocketAddress(configuration.listenAddress, configuration.webServiceConnector.port), builder.packetListeners);
    }

    private synchronized void start(Undertow undertow) {
        undertow.start();
        this.undertows.add(undertow);
    }

    public synchronized void stopAll() {
        block12: {
            block11: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("The server is stopping...");
                }
                this.executeListener(this.shutdownListeners);
                if (this.udpServer != null) {
                    try {
                        this.udpServer.shutdown();
                    }
                    catch (InterruptedException e) {
                        if (!LOGGER.isWarnEnabled()) break block11;
                        LOGGER.warn(e.getMessage(), e);
                    }
                }
            }
            for (DeploymentManager manager : this.deploymentManagers) {
                try {
                    if (manager.getState() == DeploymentManager.State.STARTED) {
                        manager.stop();
                    }
                    if (manager.getState() != DeploymentManager.State.DEPLOYED) continue;
                    manager.undeploy();
                }
                catch (ServletException e) {
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("Cannot stop the manager: " + e.getMessage(), e);
                }
            }
            this.undertows.forEach(Undertow::stop);
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                if (!LOGGER.isWarnEnabled()) break block12;
                LOGGER.warn(e.getMessage(), e);
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The server is stopped.");
        }
    }

    private IdentityManager getIdentityManager(ServerConfiguration.WebConnector connector) throws IOException {
        if (this.identityManagerProvider == null || connector == null || connector.realm == null) {
            return null;
        }
        return this.identityManagerProvider.getIdentityManager(connector.realm);
    }

    private void startHttpServer(ServerConfiguration.WebConnector connector, DeploymentInfo deploymentInfo, Logger accessLogger, String jmxName) throws IOException, ServletException, OperationsException, MBeanException {
        this.contextAttributes.forEach(deploymentInfo::addServletContextAttribute);
        if (deploymentInfo.getIdentityManager() != null) {
            deploymentInfo.setLoginConfig(Servlets.loginConfig("BASIC", connector.realm));
        }
        DeploymentManager manager = this.servletContainer.addDeployment(deploymentInfo);
        manager.deploy();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Start the connector " + this.configuration.listenAddress + ":" + connector.port);
        }
        HttpHandler httpHandler = manager.start();
        LogMetricsHandler logMetricsHandler = new LogMetricsHandler(httpHandler, accessLogger, this.configuration.listenAddress, connector.port, jmxName);
        this.deploymentManagers.add(manager);
        httpHandler = logMetricsHandler;
        Undertow.Builder servletBuilder = Undertow.builder().addHttpListener(connector.port, this.configuration.listenAddress).setServerOption(UndertowOptions.NO_REQUEST_TIMEOUT, 10000).setHandler(httpHandler);
        this.start(servletBuilder.build());
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("type", "connector");
        props.put("name", jmxName);
        ObjectName name = new ObjectName("com.qwazr.server." + this.hashCode(), props);
        mbs.registerMBean(logMetricsHandler, name);
        this.connectorsStatistics.add(logMetricsHandler);
    }

    public final void start(boolean shutdownHook) throws IOException, ServletException, ReflectiveOperationException, OperationsException, MBeanException {
        IdentityManager identityManager;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The server is starting...");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Data directory sets to: " + this.configuration.dataDirectory);
        }
        java.util.logging.Logger.getLogger("").setLevel(Level.WARNING);
        if (!this.configuration.dataDirectory.exists()) {
            throw new IOException("The data directory does not exists: " + this.configuration.dataDirectory);
        }
        if (!this.configuration.dataDirectory.isDirectory()) {
            throw new IOException("The data directory path is not a directory: " + this.configuration.dataDirectory);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Data directory sets to: " + this.configuration.dataDirectory);
        }
        if (this.udpServer != null) {
            this.udpServer.checkStarted();
        }
        if (this.servletInfos != null && !this.servletInfos.isEmpty()) {
            identityManager = this.getIdentityManager(this.configuration.webAppConnector);
            this.startHttpServer(this.configuration.webAppConnector, ServletApplication.getDeploymentInfo(this.servletInfos, identityManager, this.filterInfos, this.listenerInfos, this.sessionPersistenceManager, this.sessionListener), this.servletAccessLogger, "WEBAPP");
        }
        if (this.webServices != null && !this.webServices.isEmpty()) {
            identityManager = this.getIdentityManager(this.configuration.webServiceConnector);
            this.startHttpServer(this.configuration.webServiceConnector, RestApplication.getDeploymentInfo(identityManager), this.restAccessLogger, "WEBSERVICE");
        }
        if (shutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    GenericServer.this.stopAll();
                }
            });
        }
        this.executeListener(this.startedListeners);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("The server started successfully.");
        }
    }

    public Collection<ConnectorStatisticsMXBean> getConnectorsStatistics() {
        return this.connectorsStatistics;
    }

    private void executeListener(Collection<Listener> listeners) {
        if (listeners == null) {
            return;
        }
        listeners.forEach(listener -> {
            try {
                listener.accept(this);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
            }
        });
    }

    public static Builder of(ServerConfiguration config, ExecutorService executorService) {
        return new Builder(config, executorService);
    }

    public static class Builder {
        final ServerConfiguration configuration;
        final ExecutorService executorService;
        final Map<String, Object> contextAttributes;
        final Collection<Class<?>> webServices;
        final Collection<String> webServicePaths;
        final Collection<String> webServiceNames;
        final Collection<UdpServerThread.PacketListener> packetListeners;
        final Collection<SecurableServletInfo> servletInfos;
        final Collection<ServletInfo> securedServlets;
        final Map<String, FilterInfo> filterInfos;
        final Collection<ListenerInfo> listenerInfos;
        SessionPersistenceManager sessionPersistenceManager;
        SessionListener sessionListener;
        Logger servletAccessLogger;
        Logger restAccessLogger;
        IdentityManagerProvider identityManagerProvider;
        final Collection<Listener> startedListeners;
        final Collection<Listener> shutdownListeners;

        private Builder(ServerConfiguration configuration, ExecutorService executorService) {
            this.configuration = configuration;
            this.executorService = executorService;
            this.contextAttributes = new LinkedHashMap<String, Object>();
            this.webServices = new LinkedHashSet();
            this.webServicePaths = new LinkedHashSet<String>();
            this.webServiceNames = new LinkedHashSet<String>();
            this.packetListeners = new LinkedHashSet<UdpServerThread.PacketListener>();
            this.servletInfos = new LinkedHashSet<SecurableServletInfo>();
            this.securedServlets = new HashSet<ServletInfo>();
            this.filterInfos = new LinkedHashMap<String, FilterInfo>();
            this.listenerInfos = new LinkedHashSet<ListenerInfo>();
            this.sessionPersistenceManager = null;
            this.identityManagerProvider = null;
            this.sessionListener = null;
            this.servletAccessLogger = null;
            this.restAccessLogger = null;
            this.startedListeners = new LinkedHashSet<Listener>();
            this.shutdownListeners = new LinkedHashSet<Listener>();
        }

        public ServerConfiguration getConfiguration() {
            return this.configuration;
        }

        public GenericServer build() throws IOException {
            return new GenericServer(this);
        }

        public Builder webService(Class<?> webService) {
            ServiceName serviceName = AnnotationsUtils.getFirstAnnotation(webService, ServiceName.class);
            Objects.requireNonNull(serviceName, "The ServiceName annotation is missing for " + webService);
            this.webServices.add(webService);
            this.webServiceNames.add(serviceName.value());
            Path path = AnnotationsUtils.getFirstAnnotation(webService, Path.class);
            if (path != null && path.value() != null) {
                this.webServicePaths.add(path.value());
            }
            return this;
        }

        public Builder packetListener(UdpServerThread.PacketListener packetListener) {
            this.packetListeners.add(packetListener);
            return this;
        }

        public Builder contextAttribute(String name, Object object) {
            Objects.requireNonNull(object, "The context attribute " + name + " is null");
            this.contextAttributes.put(name, object);
            return this;
        }

        public Builder contextAttribute(Object object) {
            Objects.requireNonNull(object, "The context attribute object is null");
            return this.contextAttribute(object.getClass().getName(), object);
        }

        public Builder servlet(SecurableServletInfo servlet) {
            this.servletInfos.add(servlet);
            return this;
        }

        public Builder filter(String path, FilterInfo filter) {
            this.filterInfos.put(path, filter);
            return this;
        }

        public Builder listener(ListenerInfo listener) {
            this.listenerInfos.add(listener);
            return this;
        }

        public Builder startedListener(Listener listener) {
            this.startedListeners.add(listener);
            return this;
        }

        public Builder shutdownListener(Listener listener) {
            this.shutdownListeners.add(listener);
            return this;
        }

        public Builder sessionPersistenceManager(SessionPersistenceManager manager) {
            this.sessionPersistenceManager = manager;
            return this;
        }

        public Builder identityManagerProvider(IdentityManagerProvider provider) {
            this.identityManagerProvider = provider;
            return this;
        }

        public Builder sessionListener(SessionListener sessionListener) {
            this.sessionListener = sessionListener;
            return this;
        }

        public Builder servletAccessLogger(Logger logger2) {
            this.servletAccessLogger = logger2;
            return this;
        }

        public Builder restAccessLogger(Logger logger2) {
            this.restAccessLogger = logger2;
            return this;
        }
    }

    public static interface IdentityManagerProvider {
        public IdentityManager getIdentityManager(String var1) throws IOException;
    }

    public static interface Listener {
        public void accept(GenericServer var1);
    }
}

