/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import com.qwazr.utils.SerializationUtils;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InFileSessionPersistenceManager
implements SessionPersistenceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InFileSessionPersistenceManager.class);
    private final File sessionDir;

    public InFileSessionPersistenceManager(File sessionDir) {
        this.sessionDir = sessionDir;
    }

    @Override
    public void persistSessions(String deploymentName, Map<String, SessionPersistenceManager.PersistentSession> sessionData) {
        if (sessionData == null) {
            return;
        }
        File deploymentDir = new File(this.sessionDir, deploymentName);
        if (!deploymentDir.exists()) {
            deploymentDir.mkdir();
        }
        if (!deploymentDir.exists() && !deploymentDir.isDirectory()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Cannot create the session directory " + deploymentDir + ": persistence aborted.");
            }
            return;
        }
        sessionData.forEach((sessionId, persistentSession) -> this.writeSession(deploymentDir, (String)sessionId, (SessionPersistenceManager.PersistentSession)persistentSession));
    }

    private void writeSession(File deploymentDir, String sessionId, SessionPersistenceManager.PersistentSession persistentSession) {
        block28: {
            Date expDate = persistentSession.getExpiration();
            if (expDate == null) {
                return;
            }
            Map<String, Object> sessionData = persistentSession.getSessionData();
            if (sessionData == null || sessionData.isEmpty()) {
                return;
            }
            File sessionFile = new File(deploymentDir, sessionId);
            try (FileOutputStream fileOutputStream = new FileOutputStream(sessionFile);
                 ObjectOutputStream out = new ObjectOutputStream(fileOutputStream);){
                out.writeLong(expDate.getTime());
                sessionData.forEach((attribute, object) -> this.writeSessionAttribute(out, (String)attribute, object));
            }
            catch (IOException e) {
                if (!LOGGER.isWarnEnabled()) break block28;
                LOGGER.warn("Cannot save sessions in " + sessionFile + " " + e.getMessage(), e);
            }
        }
    }

    private void writeSessionAttribute(ObjectOutputStream out, String attribute, Object object) {
        if (attribute == null || object == null) {
            return;
        }
        if (!(object instanceof Serializable)) {
            return;
        }
        try {
            out.writeUTF(attribute);
        }
        catch (IOException e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Cannot write session attribute " + attribute + ": persistence aborted.");
            }
            return;
        }
        try {
            out.writeObject(object);
            return;
        }
        catch (IOException e) {
            block10: {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Cannot write session object " + object);
                }
                try {
                    out.writeObject(SerializationUtils.NullEmptyObject.INSTANCE);
                }
                catch (IOException e1) {
                    if (!LOGGER.isWarnEnabled()) break block10;
                    LOGGER.warn("Cannot write NULL session object for attribute " + attribute + ": persistence aborted.");
                }
            }
            return;
        }
    }

    @Override
    public Map<String, SessionPersistenceManager.PersistentSession> loadSessionAttributes(String deploymentName, ClassLoader classLoader) {
        File deploymentDir = new File(this.sessionDir, deploymentName);
        if (!deploymentDir.exists() || !deploymentDir.isDirectory()) {
            return null;
        }
        File[] sessionFiles = deploymentDir.listFiles(FileFileFilter.FILE);
        if (sessionFiles == null || sessionFiles.length == 0) {
            return null;
        }
        long time = System.currentTimeMillis();
        HashMap<String, SessionPersistenceManager.PersistentSession> finalMap = new HashMap<String, SessionPersistenceManager.PersistentSession>();
        for (File sessionFile : sessionFiles) {
            SessionPersistenceManager.PersistentSession persistentSession = this.readSession(sessionFile);
            if (persistentSession != null && persistentSession.getExpiration().getTime() > time) {
                finalMap.put(sessionFile.getName(), persistentSession);
            }
            sessionFile.delete();
        }
        return finalMap.isEmpty() ? null : finalMap;
    }

    /*
     * Exception decompiling
     */
    private SessionPersistenceManager.PersistentSession readSession(File sessionFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void readSessionAttribute(ObjectInputStream in, Map<String, Object> sessionData) throws IOException {
        block3: {
            String attribute = in.readUTF();
            try {
                Object object = in.readObject();
                if (!(object instanceof SerializationUtils.NullEmptyObject)) {
                    sessionData.put(attribute, object);
                }
            }
            catch (NotSerializableException | ClassNotFoundException e) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn("The attribute " + attribute + " cannot be deserialized: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void clear(String deploymentName) {
    }
}

