/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import com.qwazr.server.ConnectorStatisticsMXBean;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class LogMetricsHandler
implements HttpHandler,
ConnectorStatisticsMXBean {
    private final String address;
    private final int port;
    private final String name;
    private final HttpHandler next;
    private final Logger logger;
    public final AtomicInteger active;
    public final AtomicInteger maxActive;

    LogMetricsHandler(HttpHandler next, Logger logger2, String address, int port, String name) {
        this.next = next;
        this.logger = logger2;
        this.active = new AtomicInteger();
        this.maxActive = new AtomicInteger();
        this.address = address;
        this.port = port;
        this.name = name;
    }

    @Override
    public final void handleRequest(HttpServerExchange exchange) throws Exception {
        int act;
        if (this.logger != null) {
            exchange.addExchangeCompleteListener(new CompletionListener());
        }
        if ((act = this.active.incrementAndGet()) > this.maxActive.get()) {
            this.maxActive.set(act);
        }
        try {
            this.next.handleRequest(exchange);
        }
        finally {
            this.active.decrementAndGet();
        }
    }

    @Override
    public final int getActiveCount() {
        return this.active.get();
    }

    @Override
    public final int getMaxActiveCount() {
        return this.maxActive.get();
    }

    @Override
    public final String getAddress() {
        return this.address;
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void reset() {
        this.maxActive.set(0);
    }

    private static String getUsername(SecurityContext securityContext) {
        if (!securityContext.isAuthenticated()) {
            return null;
        }
        Account account = securityContext.getAuthenticatedAccount();
        if (account == null) {
            return null;
        }
        Principal principal = account.getPrincipal();
        if (principal == null) {
            return null;
        }
        return principal.getName();
    }

    private static void span2(StringBuilder sb, int value) {
        if (value < 10) {
            sb.append('0');
        }
        sb.append(value);
    }

    private static void span3(StringBuilder sb, int value) {
        if (value < 10) {
            sb.append("00");
        } else if (value < 100) {
            sb.append('0');
        }
        sb.append(value);
    }

    private static String getDate(Calendar calendar) {
        StringBuilder sb = new StringBuilder();
        sb.append(calendar.get(1));
        sb.append('-');
        LogMetricsHandler.span2(sb, calendar.get(2) + 1);
        sb.append('-');
        LogMetricsHandler.span2(sb, calendar.get(5));
        return sb.toString();
    }

    private static String getTime(Calendar calendar) {
        StringBuilder sb = new StringBuilder();
        LogMetricsHandler.span2(sb, calendar.get(11));
        sb.append(':');
        LogMetricsHandler.span2(sb, calendar.get(12));
        sb.append(':');
        LogMetricsHandler.span2(sb, calendar.get(13));
        sb.append('.');
        LogMetricsHandler.span3(sb, calendar.get(14));
        return sb.toString();
    }

    private class CompletionListener
    implements ExchangeCompletionListener {
        private final long startTime = System.currentTimeMillis();

        private CompletionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                HeaderMap requestHeaders = exchange.getRequestHeaders();
                Calendar calendar = Calendar.getInstance();
                InetSocketAddress destinationAddress = exchange.getDestinationAddress();
                InetSocketAddress sourceAddress = exchange.getSourceAddress();
                long endTime = System.currentTimeMillis();
                MDC.put("c-ip", sourceAddress.getAddress().getHostAddress());
                MDC.put("cs-host", sourceAddress.getHostName());
                MDC.put("cs-method", exchange.getRequestMethod().toString());
                MDC.put("cs-uri-query", exchange.getQueryString());
                MDC.put("cs-uri-stem", exchange.getRequestPath());
                MDC.put("cs-user-agent", requestHeaders.getFirst("User-Agent"));
                MDC.put("cs-username", LogMetricsHandler.getUsername(exchange.getSecurityContext()));
                MDC.put("cs-x-forwarded-for", requestHeaders.getFirst("X-Forwarded-For"));
                MDC.put("date", LogMetricsHandler.getDate(calendar));
                MDC.put("cs-referer", requestHeaders.getFirst("Referer"));
                MDC.put("sc-status", Integer.toString(exchange.getStatusCode()));
                MDC.put("s-ip", destinationAddress.getAddress().getHostAddress());
                MDC.put("s-port", Integer.toString(destinationAddress.getPort()));
                MDC.put("time", LogMetricsHandler.getTime(calendar));
                MDC.put("time-taken", Long.toString(endTime - this.startTime));
                MDC.put("cs-bytes", Long.toString(exchange.getRequestContentLength()));
                MDC.put("sc-bytes", Long.toString(exchange.getResponseBytesSent()));
                LogMetricsHandler.this.logger.info("");
                MDC.clear();
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

