/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.qwazr.utils.LinkUtils;
import com.qwazr.utils.StringUtils;
import com.qwazr.utils.UBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RemoteService {
    public static final String TIMEOUT_PARAMETER = "timeout";
    public final String scheme;
    public final String host;
    public final String path;
    public final Integer port;
    public final Integer timeout;
    public final String username;
    public final String password;
    @JsonIgnore
    public final String serverAddress;
    @JsonIgnore
    public final String serviceAddress;

    public RemoteService() {
        this.scheme = null;
        this.host = null;
        this.port = null;
        this.path = null;
        this.timeout = null;
        this.username = null;
        this.password = null;
        this.serverAddress = null;
        this.serviceAddress = null;
    }

    protected RemoteService(Builder builder) {
        this.scheme = builder.scheme == null ? "http" : builder.scheme;
        this.host = builder.host == null ? "localhost" : builder.host;
        this.path = builder.getPathSegment(0);
        this.port = builder.port == null ? 9091 : (builder.port == -1 ? 9091 : builder.port);
        this.timeout = builder.timeout;
        this.username = builder.username;
        this.password = builder.password;
        this.serverAddress = (this.scheme + "://" + this.host + ':' + this.port).intern();
        this.serviceAddress = (this.serverAddress + '/' + (this.path == null ? "" : this.path)).intern();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof RemoteService)) {
            return false;
        }
        RemoteService rs = (RemoteService)o;
        if (!Objects.equals(this.scheme, rs.scheme)) {
            return false;
        }
        if (!Objects.equals(this.host, rs.host)) {
            return false;
        }
        if (!Objects.equals(this.port, rs.port)) {
            return false;
        }
        if (!Objects.equals(this.path, rs.path)) {
            return false;
        }
        if (!Objects.equals(this.timeout, rs.timeout)) {
            return false;
        }
        if (!Objects.equals(this.username, rs.username)) {
            return false;
        }
        if (!Objects.equals(this.password, rs.password)) {
            return false;
        }
        if (!Objects.equals(this.serverAddress, rs.serverAddress)) {
            return false;
        }
        return Objects.equals(this.serviceAddress, rs.serviceAddress);
    }

    @JsonIgnore
    public final Credentials getCredentials() {
        return this.username == null ? null : new UsernamePasswordCredentials(this.username, this.password);
    }

    public static Builder of() {
        return new Builder();
    }

    public static Builder of(URI uri) {
        return new Builder(uri);
    }

    public static Builder of(String url) throws URISyntaxException {
        return new Builder(url);
    }

    public static List<Builder> builders(String ... remoteServiceURLs) throws URISyntaxException {
        if (remoteServiceURLs == null || remoteServiceURLs.length == 0) {
            return null;
        }
        ArrayList<Builder> builderList = new ArrayList<Builder>();
        for (String url : remoteServiceURLs) {
            if (url == null || url.isEmpty()) continue;
            builderList.add(new Builder(url));
        }
        return builderList.isEmpty() ? null : builderList;
    }

    public static List<Builder> builders(Collection<String> remoteServiceURLs) throws URISyntaxException {
        if (remoteServiceURLs == null || remoteServiceURLs.isEmpty()) {
            return null;
        }
        ArrayList<Builder> builderList = new ArrayList<Builder>();
        for (String url : remoteServiceURLs) {
            if (url == null || url.isEmpty()) continue;
            builderList.add(new Builder(url));
        }
        return builderList.isEmpty() ? null : builderList;
    }

    private static RemoteService[] fromBuilders(Collection<Builder> builders) {
        if (builders == null || builders.isEmpty()) {
            return null;
        }
        int i = 0;
        RemoteService[] remotes = new RemoteService[builders.size()];
        for (Builder builder : builders) {
            remotes[i++] = new RemoteService(builder);
        }
        return remotes;
    }

    public static RemoteService[] build(String ... remoteServiceURLs) throws URISyntaxException {
        return RemoteService.fromBuilders(RemoteService.builders(remoteServiceURLs));
    }

    public static RemoteService[] build(Collection<String> remoteServiceURLs) throws URISyntaxException {
        return RemoteService.fromBuilders(RemoteService.builders(remoteServiceURLs));
    }

    public static UBuilder getNewUBuilder(RemoteService remote, String ... paths) {
        UBuilder builder = new UBuilder();
        StringBuilder sb = new StringBuilder();
        if (remote.path != null) {
            sb.append(remote.path);
        }
        if (paths != null) {
            for (String path : paths) {
                if (path == null) continue;
                sb.append(path);
            }
        }
        builder.setScheme(remote.scheme == null ? "http" : remote.scheme).setHost(remote.host == null ? "localhost" : remote.host).setPort(remote.port == null ? 9091 : remote.port);
        if (sb.length() > 0) {
            builder.setPath(sb.toString());
        }
        return builder;
    }

    public static class Builder {
        private final URI initialURI;
        private String scheme;
        private String host;
        private String[] pathSegments;
        private Integer port;
        private Integer timeout;
        private String username;
        private String password;
        private MultivaluedMap<String, String> queryParams;

        private Builder() {
            this.initialURI = null;
            this.scheme = null;
            this.host = null;
            this.pathSegments = null;
            this.port = null;
            this.timeout = null;
            this.username = null;
            this.password = null;
            this.queryParams = null;
        }

        private Builder(URI uri) {
            this.initialURI = uri;
            this.setScheme(uri.getScheme());
            this.setHost(uri.getHost());
            this.setPath(uri.getPath());
            this.setPort(uri.getPort());
            this.setUserInfo(uri.getUserInfo());
            this.setQuery(uri.getQuery());
        }

        private Builder(String url) throws URISyntaxException {
            this(new URI(url));
        }

        public URI getInitialURI() {
            return this.initialURI;
        }

        public Builder setScheme(String scheme) {
            this.scheme = scheme == null ? "http" : scheme;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host == null ? "localhost" : host;
            return this;
        }

        public Builder setPath(String path) {
            this.pathSegments = path == null ? null : StringUtils.split(path, '/');
            return this;
        }

        public String getPathSegment(int pos) {
            if (this.pathSegments == null) {
                return null;
            }
            return this.pathSegments.length > pos ? this.pathSegments[pos] : null;
        }

        public Builder setPort(Integer port) {
            this.port = port == null ? 9091 : (port == -1 ? 9091 : port);
            return this;
        }

        public Builder setUserInfo(String userInfo) {
            String[] s;
            String[] stringArray = s = userInfo != null ? StringUtils.split(userInfo, ':') : null;
            if (s != null) {
                this.username = s.length > 0 ? s[0] : null;
                this.password = s.length > 1 ? s[1] : null;
            } else {
                this.username = null;
                this.password = null;
            }
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setTimeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setQuery(String query) {
            this.queryParams = LinkUtils.getQueryParameters(query);
            if (this.queryParams == null) {
                return this;
            }
            String s = this.queryParams.getFirst(RemoteService.TIMEOUT_PARAMETER);
            if (s != null) {
                this.setTimeout(Integer.parseInt(s));
            }
            return this;
        }

        public String getQueryParam(String param) {
            return this.queryParams == null ? null : this.queryParams.getFirst(param);
        }

        public List<String> getQueryParams(String param) {
            return this.queryParams == null ? null : (List)this.queryParams.get(param);
        }

        public RemoteService build() {
            return new RemoteService(this);
        }
    }
}

