/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.qwazr.server.GenericServer;
import com.qwazr.server.JsonMappingExceptionMapper;
import com.qwazr.utils.json.JacksonConfig;
import io.undertow.security.idm.IdentityManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletInfo;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.glassfish.jersey.servlet.ServletContainer;

public class RestApplication
extends Application {
    @Context
    private ServletContext context;

    protected <T> T getContextAttribute(Class<T> clazz) {
        return (T)(this.context == null || clazz == null ? null : this.context.getAttribute(clazz.getName()));
    }

    static DeploymentInfo getDeploymentInfo(IdentityManager identityManager) {
        DeploymentInfo deploymentInfo = Servlets.deployment().setClassLoader(RestApplication.class.getClassLoader()).setContextPath("/").setDeploymentName("REST");
        Class applicationClass = identityManager == null ? WithoutAuth.class : WithAuth.class;
        deploymentInfo.addServlets(new ServletInfo("REST", ServletContainer.class).addInitParam("javax.ws.rs.Application", applicationClass.getName()).setAsyncSupported(true).addMapping("/*"));
        if (identityManager != null) {
            deploymentInfo.setIdentityManager(identityManager);
            deploymentInfo.addSecurityConstraint(((SecurityConstraint)Servlets.securityConstraint().setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.AUTHENTICATE)).addWebResourceCollection(Servlets.webResourceCollection().addUrlPattern("/*")));
        }
        return deploymentInfo;
    }

    public static class WithAuth
    extends WithoutAuth {
        @Override
        public Set<Class<?>> getClasses() {
            Set<Class<?>> classes = super.getClasses();
            classes.add(RolesAllowedDynamicFeature.class);
            return classes;
        }
    }

    public static class WithoutAuth
    extends RestApplication {
        @Override
        public Set<Class<?>> getClasses() {
            LinkedHashSet classes = new LinkedHashSet();
            classes.add(JacksonConfig.class);
            classes.add(JacksonJsonProvider.class);
            classes.add(JsonMappingExceptionMapper.class);
            GenericServer server = this.getContextAttribute(GenericServer.class);
            if (server != null) {
                server.forEachWebServices(classes::add);
            }
            return classes;
        }
    }
}

