/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import com.qwazr.server.response.JsonExceptionReponse;
import com.qwazr.utils.StringUtils;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.client.HttpResponseException;
import org.slf4j.Logger;

public class ServerException
extends RuntimeException {
    private static final long serialVersionUID = -6102827990391082335L;
    private final int statusCode;
    private final String message;
    private static final int INTERNAL_SERVER_ERROR = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();

    public ServerException(Response.Status status, String message, Exception exception) {
        super(message, exception);
        if (status == null && exception != null) {
            this.statusCode = exception instanceof WebApplicationException ? ((WebApplicationException)exception).getResponse().getStatus() : (exception instanceof HttpResponseException ? ((HttpResponseException)exception).getStatusCode() : INTERNAL_SERVER_ERROR);
        } else {
            int n = this.statusCode = status != null ? status.getStatusCode() : INTERNAL_SERVER_ERROR;
        }
        if (StringUtils.isEmpty(message)) {
            if (exception != null) {
                message = exception.getMessage();
            }
            if (StringUtils.isEmpty(message) && status != null) {
                message = status.getReasonPhrase();
            }
        }
        this.message = message;
    }

    public ServerException(Response.Status status) {
        this(status, status.getReasonPhrase(), null);
    }

    public ServerException(Response.Status status, String message) {
        this(status, message, null);
    }

    public ServerException(String message, Exception exception) {
        this(null, message, exception);
    }

    public ServerException(String message) {
        this(null, message, null);
    }

    public ServerException(Exception exception) {
        this(null, null, exception);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public final ServerException warnIfCause(Logger logger2) {
        Throwable cause = this.getCause();
        if (cause == null) {
            return this;
        }
        if (logger2.isWarnEnabled()) {
            logger2.warn(this.getMessage(), cause);
        }
        return this;
    }

    public final ServerException errorIfCause(Logger logger2) {
        Throwable cause = this.getCause();
        if (cause == null) {
            return this;
        }
        if (logger2.isErrorEnabled()) {
            logger2.error(this.getMessage(), cause);
        }
        return this;
    }

    @Override
    public final String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return super.getMessage();
    }

    private Response getTextResponse() {
        return Response.status(this.statusCode).type("text/plain").entity(this.message == null ? "" : this.message).build();
    }

    private Response getJsonResponse() {
        return new JsonExceptionReponse(this.statusCode, this.message, (Throwable)this).toResponse();
    }

    public WebApplicationException getTextException() {
        return new WebApplicationException((Throwable)this, this.getTextResponse());
    }

    public WebApplicationException getJsonException() {
        return new WebApplicationException((Throwable)this, this.getJsonResponse());
    }

    public static ServerException getServerException(Exception e) {
        Throwable cause;
        if (e instanceof ServerException) {
            return (ServerException)e;
        }
        if (e instanceof WebApplicationException && (cause = e.getCause()) != null && cause instanceof ServerException) {
            return (ServerException)cause;
        }
        return new ServerException(e);
    }

    private static WebApplicationException checkCompatible(Exception e, MediaType expectedType) {
        if (!(e instanceof WebApplicationException)) {
            return null;
        }
        WebApplicationException wae = (WebApplicationException)e;
        Response response = wae.getResponse();
        if (response == null) {
            return null;
        }
        if (!response.hasEntity()) {
            return null;
        }
        MediaType mediaType = response.getMediaType();
        if (mediaType == null) {
            return null;
        }
        if (!expectedType.isCompatible(mediaType)) {
            return null;
        }
        return wae;
    }

    public static WebApplicationException getTextException(Logger logger2, Exception e) {
        WebApplicationException wae = ServerException.checkCompatible(e, MediaType.TEXT_PLAIN_TYPE);
        if (wae != null) {
            return wae;
        }
        return ServerException.getServerException(e).warnIfCause(logger2).getTextException();
    }

    public static WebApplicationException getJsonException(Logger logger2, Exception e) {
        WebApplicationException wae = ServerException.checkCompatible(e, MediaType.APPLICATION_JSON_TYPE);
        if (wae != null) {
            return wae;
        }
        return ServerException.getServerException(e).warnIfCause(logger2).getJsonException();
    }
}

