/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import com.qwazr.server.SecurableServletInfo;
import io.undertow.security.idm.IdentityManager;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.util.Collection;
import java.util.Map;
import javax.servlet.DispatcherType;

class ServletApplication {
    ServletApplication() {
    }

    static DeploymentInfo getDeploymentInfo(Collection<SecurableServletInfo> servletInfos, IdentityManager identityManager, Map<String, FilterInfo> filterInfos, Collection<ListenerInfo> listenersInfos, SessionPersistenceManager sessionPersistenceManager, SessionListener sessionListener) {
        DeploymentInfo deploymentInfo = Servlets.deployment().setClassLoader(Thread.currentThread().getContextClassLoader()).setContextPath("/").setDefaultEncoding("UTF-8").setDeploymentName(ServletApplication.class.getName());
        if (sessionPersistenceManager != null) {
            deploymentInfo.setSessionPersistenceManager(sessionPersistenceManager);
        }
        if (identityManager != null) {
            deploymentInfo.setIdentityManager(identityManager);
        }
        if (servletInfos != null) {
            servletInfos.forEach(securableServletInfo -> {
                deploymentInfo.addServlet((ServletInfo)securableServletInfo);
                if (securableServletInfo.isSecure() && identityManager != null) {
                    deploymentInfo.addSecurityConstraint(((SecurityConstraint)Servlets.securityConstraint().setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.AUTHENTICATE)).addWebResourceCollection(Servlets.webResourceCollection().addUrlPatterns(securableServletInfo.getMappings())));
                }
            });
        }
        if (filterInfos != null) {
            filterInfos.forEach((path, filterInfo) -> {
                deploymentInfo.addFilter((FilterInfo)filterInfo);
                deploymentInfo.addFilterUrlMapping(filterInfo.getName(), (String)path, DispatcherType.REQUEST);
            });
        }
        if (listenersInfos != null) {
            deploymentInfo.addListeners(listenersInfos);
        }
        if (sessionListener != null) {
            deploymentInfo.addSessionListener(sessionListener);
        }
        return deploymentInfo;
    }
}

