/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.fileupload.RequestContext;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;

public class StreamRequestContext
implements RequestContext {
    private final String contentType;
    private final int contentLength;
    private final String encoding;
    private final InputStream inputStream;

    public StreamRequestContext(String contentType, long contentLength, String encoding, InputStream inputStream) {
        this.contentType = contentType;
        this.contentLength = (int)contentLength;
        this.encoding = encoding;
        this.inputStream = inputStream;
    }

    public StreamRequestContext(HttpEntity entity) throws IOException {
        ContentType ct = ContentType.getLenient(entity);
        this.contentType = ct.toString();
        this.contentLength = (int)entity.getContentLength();
        Charset charset = ct.getCharset();
        this.encoding = charset == null ? null : charset.name();
        this.inputStream = entity.getContent();
    }

    @Override
    public String getCharacterEncoding() {
        return this.encoding;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @Deprecated
    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStream;
    }
}

