/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpServerThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpServerThread.class);
    private final PacketListener[] packetListeners;
    private final AtomicBoolean isShutdown;
    private final InetSocketAddress socketAddress;
    private final InetAddress multicastGroupAddress;
    private final Integer multicastPort;
    private volatile DatagramSocket datagramSocket;

    private UdpServerThread(InetSocketAddress socketAddress, InetAddress multicastGroupAddress, Integer multicastPort, Collection<PacketListener> packetListeners) {
        this.setName("UDP Server");
        this.setDaemon(true);
        this.isShutdown = new AtomicBoolean(false);
        this.socketAddress = socketAddress;
        this.multicastGroupAddress = multicastGroupAddress;
        this.multicastPort = multicastPort;
        this.packetListeners = packetListeners.toArray(new PacketListener[packetListeners.size()]);
        this.datagramSocket = null;
    }

    UdpServerThread(InetSocketAddress socketAddress, Collection<PacketListener> packetListeners) {
        this(socketAddress, null, null, packetListeners);
    }

    UdpServerThread(String multicastGroupAddress, int multicastPort, Collection<PacketListener> packetListeners) throws UnknownHostException {
        this(null, InetAddress.getByName(multicastGroupAddress), multicastPort, packetListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (DatagramSocket socket = this.multicastGroupAddress != null ? new MulticastSocket(this.multicastPort) : new DatagramSocket(this.socketAddress);){
            this.datagramSocket = socket;
            if (this.multicastGroupAddress != null) {
                ((MulticastSocket)socket).joinGroup(this.multicastGroupAddress);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("UDP Server started: " + socket.getLocalSocketAddress());
            }
            while (!this.isShutdown.get()) {
                byte[] dataBuffer = new byte[65536];
                DatagramPacket datagramPacket = new DatagramPacket(dataBuffer, dataBuffer.length);
                socket.receive(datagramPacket);
                for (PacketListener packetListener : this.packetListeners) {
                    try {
                        packetListener.acceptPacket(datagramPacket);
                    }
                    catch (Exception e) {
                        LOGGER.warn(e.getMessage(), e);
                    }
                }
            }
        }
        catch (IOException e) {
            if (!this.isShutdown.get()) {
                throw new RuntimeException("Error on UDP server " + this.socketAddress, e);
            }
        }
        finally {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("UDP Server exit: " + this.socketAddress);
            }
        }
    }

    synchronized void checkStarted() throws UnknownHostException {
        if (this.isAlive()) {
            return;
        }
        this.start();
    }

    void shutdown() throws InterruptedException {
        this.isShutdown.set(true);
        if (this.datagramSocket != null) {
            if (this.multicastGroupAddress != null) {
                try {
                    ((MulticastSocket)this.datagramSocket).leaveGroup(this.multicastGroupAddress);
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage(), e);
                }
            }
            if (this.datagramSocket.isConnected()) {
                this.datagramSocket.disconnect();
            }
            if (!this.datagramSocket.isClosed()) {
                this.datagramSocket.close();
            }
            this.datagramSocket = null;
        }
    }

    public static interface PacketListener {
        public void acceptPacket(DatagramPacket var1) throws Exception;
    }
}

