/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import com.qwazr.server.GenericServer;
import com.qwazr.server.ServiceName;
import com.qwazr.server.WelcomeService;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RolesAllowed(value={"welcome"})
@Path(value="/")
@ServiceName(value="welcome")
public class WelcomeShutdownService
extends WelcomeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WelcomeShutdownService.class);

    @DELETE
    @Path(value="/shutdown")
    public void shutdown() {
        new ShutdownThread(this.getContextAttribute(GenericServer.class));
    }

    private static class ShutdownThread
    implements Runnable {
        private final GenericServer server;

        private ShutdownThread(GenericServer server) {
            this.server = server;
            new Thread(this).start();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(5000L);
                this.server.stopAll();
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage(), e);
            }
        }
    }
}

