/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.qwazr.server.GenericServer;
import com.qwazr.utils.RuntimeUtils;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WelcomeStatus {
    public final TitleVendorVersion implementation;
    public final TitleVendorVersion specification;
    public final TreeSet<String> endpoints;
    public final MemoryStatus memory;
    public final RuntimeStatus runtime;
    public final SortedMap<String, Object> properties;
    public final SortedMap<String, String> env;

    public WelcomeStatus(GenericServer server, Boolean showProperties, Boolean showEnvVars) {
        if (server != null) {
            this.endpoints = new TreeSet();
            server.forEachServicePath(this.endpoints::add);
        } else {
            this.endpoints = null;
        }
        Package pkg = this.getClass().getPackage();
        this.implementation = new TitleVendorVersion(pkg.getImplementationTitle(), pkg.getImplementationVendor(), pkg.getImplementationVersion());
        this.specification = new TitleVendorVersion(pkg.getSpecificationTitle(), pkg.getSpecificationVendor(), pkg.getSpecificationVersion());
        this.memory = new MemoryStatus();
        this.runtime = new RuntimeStatus();
        if (showProperties != null && showProperties.booleanValue()) {
            this.properties = new TreeMap<String, Object>();
            System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.properties.put(key.toString(), value)));
        } else {
            this.properties = null;
        }
        this.env = showEnvVars != null && showEnvVars != false ? new TreeMap<String, String>(System.getenv()) : null;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public class RuntimeStatus {
        public final Integer activeThreads = RuntimeUtils.getActiveThreadCount();
        public final Long openFiles = RuntimeUtils.getOpenFileCount();

        RuntimeStatus() {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public class MemoryStatus {
        public final Long free;
        public final Long total;
        public final Long max;

        MemoryStatus() {
            Runtime runtime = Runtime.getRuntime();
            this.free = runtime.freeMemory();
            this.total = runtime.totalMemory();
            this.max = runtime.maxMemory();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public class TitleVendorVersion {
        public final String title;
        public final String vendor;
        public final String version;

        TitleVendorVersion(String title, String vendor, String version) {
            this.title = title;
            this.vendor = vendor;
            this.version = version;
        }
    }
}

