/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.qwazr.server.AbstractStreamingOutput;
import com.qwazr.server.RemoteService;
import com.qwazr.server.ServerException;
import com.qwazr.server.client.JsonClientInterface;
import com.qwazr.server.response.HttpResponseHandler;
import com.qwazr.server.response.JsonHttpResponseHandler;
import com.qwazr.server.response.ResponseValidator;
import com.qwazr.server.response.StringHttpResponseHandler;
import com.qwazr.utils.IOUtils;
import com.qwazr.utils.http.HttpClients;
import com.qwazr.utils.http.HttpRequest;
import com.qwazr.utils.json.JsonMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;

public abstract class JsonClientAbstract
implements JsonClientInterface {
    public static final String CONTENT_TYPE_JSON_UTF8 = ContentType.APPLICATION_JSON.toString();
    private static final int DEFAULT_TIMEOUT;
    protected final RemoteService remote;
    private final AuthCache authCache;
    private final BasicCredentialsProvider credentialsProvider;
    private final BasicCookieStore cookieStore;

    protected JsonClientAbstract(RemoteService remote) {
        this.remote = remote;
        Credentials credentials = remote.getCredentials();
        this.authCache = new BasicAuthCache();
        this.credentialsProvider = new BasicCredentialsProvider();
        if (credentials != null) {
            this.credentialsProvider.setCredentials(AuthScope.ANY, credentials);
        }
        this.cookieStore = new BasicCookieStore();
    }

    private HttpClientContext getContext(Integer msTimeOut) {
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider(this.credentialsProvider);
        context.setAuthCache(this.authCache);
        context.setCookieStore(this.cookieStore);
        RequestConfig.Builder requestConfig = RequestConfig.custom();
        int timeout = msTimeOut != null ? msTimeOut : (this.remote.timeout != null ? this.remote.timeout : DEFAULT_TIMEOUT);
        requestConfig.setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout);
        context.setAttribute("http.request-config", requestConfig.build());
        return context;
    }

    private void setBody(HttpRequest request, Object bodyObject) throws JsonProcessingException {
        if (bodyObject == null) {
            return;
        }
        HttpRequest.Entity requestEntity = (HttpRequest.Entity)request;
        if (bodyObject instanceof String) {
            requestEntity.bodyString(bodyObject.toString(), ContentType.TEXT_PLAIN);
        } else if (bodyObject instanceof InputStream) {
            requestEntity.bodyStream((InputStream)bodyObject, ContentType.APPLICATION_OCTET_STREAM);
        } else {
            requestEntity.bodyString(JsonMapper.MAPPER.writeValueAsString(bodyObject), ContentType.APPLICATION_JSON);
        }
    }

    private <T> T executeJsonEx(HttpRequest request, Object bodyObject, Integer msTimeOut, Class<T> jsonResultClass, ResponseValidator validator) throws IOException {
        this.setBody(request, bodyObject);
        JsonHttpResponseHandler.JsonValueResponse<T> responseHandler = new JsonHttpResponseHandler.JsonValueResponse<T>(jsonResultClass, validator);
        request.addHeader("Accept", CONTENT_TYPE_JSON_UTF8);
        return HttpClients.HTTP_CLIENT.execute((HttpUriRequest)request.request, responseHandler, (HttpContext)this.getContext(msTimeOut));
    }

    @Override
    public final <T> T executeJson(HttpRequest request, Object body, Integer msTimeOut, Class<T> objectClass, ResponseValidator validator) {
        try {
            return this.executeJsonEx(request, body, msTimeOut, objectClass, validator);
        }
        catch (IOException e) {
            throw ServerException.getServerException(e).getJsonException();
        }
    }

    private <T> T executeJsonEx(HttpRequest request, Object bodyObject, Integer msTimeOut, TypeReference<T> typeRef, ResponseValidator validator) throws IOException {
        this.setBody(request, bodyObject);
        return HttpClients.HTTP_CLIENT.execute((HttpUriRequest)request.addHeader((String)"accept", (String)JsonClientAbstract.CONTENT_TYPE_JSON_UTF8).request, new JsonHttpResponseHandler.JsonValueTypeRefResponse<T>(typeRef, validator), (HttpContext)this.getContext(msTimeOut));
    }

    @Override
    public final <T> T executeJson(HttpRequest request, Object body, Integer msTimeOut, TypeReference<T> typeRef, ResponseValidator validator) {
        try {
            return this.executeJsonEx(request, body, msTimeOut, typeRef, validator);
        }
        catch (IOException e) {
            throw ServerException.getServerException(e).getJsonException();
        }
    }

    private JsonNode executeJsonNodeEx(HttpRequest request, Object bodyObject, Integer msTimeOut, ResponseValidator validator) throws IOException {
        this.setBody(request, bodyObject);
        return HttpClients.HTTP_CLIENT.execute((HttpUriRequest)request.addHeader((String)"accept", (String)JsonClientAbstract.CONTENT_TYPE_JSON_UTF8).request, new JsonHttpResponseHandler.JsonTreeResponse(validator), (HttpContext)this.getContext(msTimeOut));
    }

    @Override
    public final JsonNode executeJsonNode(HttpRequest request, Object body, Integer msTimeOut, ResponseValidator validator) {
        try {
            return this.executeJsonNodeEx(request, body, msTimeOut, validator);
        }
        catch (IOException e) {
            throw ServerException.getServerException(e).getJsonException();
        }
    }

    private HttpResponse executeEx(HttpRequest request, Object bodyObject, Integer msTimeOut, ResponseValidator validator) throws IOException {
        this.setBody(request, bodyObject);
        return HttpClients.HTTP_CLIENT.execute((HttpUriRequest)request.request, new HttpResponseHandler(validator), (HttpContext)this.getContext(msTimeOut));
    }

    @Override
    public final HttpResponse execute(HttpRequest request, Object bodyObject, Integer msTimeOut, ResponseValidator validator) {
        try {
            return this.executeEx(request, bodyObject, msTimeOut, validator);
        }
        catch (IOException e) {
            throw ServerException.getServerException(e).getTextException();
        }
    }

    @Override
    public final Integer executeStatusCode(HttpRequest request, Object bodyObject, Integer msTimeOut, ResponseValidator validator) {
        try {
            HttpResponse response = this.executeEx(request, bodyObject, msTimeOut, validator);
            return response.getStatusLine().getStatusCode();
        }
        catch (IOException e) {
            throw ServerException.getServerException(e).getTextException();
        }
    }

    private String executeStringEx(HttpRequest request, Object bodyObject, Integer msTimeOut, ResponseValidator validator) throws IOException {
        this.setBody(request, bodyObject);
        return HttpClients.HTTP_CLIENT.execute((HttpUriRequest)request.request, new StringHttpResponseHandler(validator), (HttpContext)this.getContext(msTimeOut));
    }

    @Override
    public final String executeString(HttpRequest request, Object bodyObject, Integer msTimeOut, ResponseValidator validator) {
        try {
            return this.executeStringEx(request, bodyObject, msTimeOut, validator);
        }
        catch (IOException e) {
            throw ServerException.getServerException(e).getTextException();
        }
    }

    private AbstractStreamingOutput executeStreamEx(HttpRequest request, Object bodyObject, Integer msTimeOut, ResponseValidator validator) throws IOException {
        this.setBody(request, bodyObject);
        CloseableHttpResponse response = HttpClients.HTTP_CLIENT.execute((HttpUriRequest)request.request, this.getContext(msTimeOut));
        if (validator != null) {
            try {
                validator.checkResponse(response.getAllHeaders(), response.getStatusLine(), response.getEntity());
            }
            catch (ClientProtocolException e) {
                IOUtils.closeQuietly((Closeable)response);
                throw e;
            }
        }
        return AbstractStreamingOutput.with(response);
    }

    @Override
    public final AbstractStreamingOutput executeStream(HttpRequest request, Object bodyObject, Integer msTimeOut, ResponseValidator validator) {
        try {
            return this.executeStreamEx(request, bodyObject, msTimeOut, validator);
        }
        catch (IOException e) {
            throw ServerException.getServerException(e).getTextException();
        }
    }

    static {
        String s = System.getProperty("com.qwazr.server.client.default_timeout");
        DEFAULT_TIMEOUT = s == null ? 60000 : Integer.parseInt(s);
    }
}

