/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server.client;

import com.qwazr.server.RemoteService;
import com.qwazr.utils.RandomArrayIterator;
import java.util.HashMap;
import java.util.Iterator;

public abstract class JsonMultiClientAbstract<T>
implements Iterable<T> {
    private final T[] clientsArray;
    private final HashMap<String, T> clientsMap;

    protected JsonMultiClientAbstract(T[] clientArray, RemoteService ... remotes) {
        this.clientsArray = clientArray;
        this.clientsMap = new HashMap();
        for (RemoteService remote : remotes) {
            this.clientsMap.put(remote.serverAddress, this.newClient(remote));
        }
        this.clientsMap.values().toArray(this.clientsArray);
    }

    protected abstract T newClient(RemoteService var1);

    @Override
    public Iterator<T> iterator() {
        return new RandomArrayIterator<T>(this.clientsArray);
    }

    public int size() {
        return this.clientsArray.length;
    }

    public T getClientByUrl(String serverAddress) {
        return this.clientsMap.get(serverAddress);
    }

    protected T getClientByPos(Integer pos) {
        return this.clientsArray[pos];
    }
}

