/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server.configuration;

import com.qwazr.utils.WildcardMatcher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.filefilter.IOFileFilter;

public class ConfigurationFileFilter
implements IOFileFilter {
    private final List<Matcher> patterns = new ArrayList<Matcher>();
    private final boolean noMatchResult;

    ConfigurationFileFilter(String[] patternArray) {
        if (patternArray == null) {
            this.noMatchResult = true;
            return;
        }
        int inclusionCount = 0;
        for (String pattern : patternArray) {
            if (pattern.startsWith("!")) {
                this.patterns.add(new Matcher(pattern.substring(1), false));
                continue;
            }
            this.patterns.add(new Matcher(pattern, true));
            ++inclusionCount;
        }
        this.noMatchResult = inclusionCount == 0;
    }

    @Override
    public final boolean accept(File pathname) {
        return this.accept(pathname.getParentFile(), pathname.getName());
    }

    @Override
    public final boolean accept(File dir, String name) {
        if (this.patterns == null || this.patterns.isEmpty()) {
            return true;
        }
        for (Matcher matcher : this.patterns) {
            if (!matcher.match(name)) continue;
            return matcher.result;
        }
        return this.noMatchResult;
    }

    private class Matcher
    extends WildcardMatcher {
        private final boolean result;

        public Matcher(String pattern, boolean result) {
            super(pattern);
            this.result = result;
        }
    }
}

