/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server.configuration;

import com.qwazr.server.configuration.ConfigurationFileFilter;
import com.qwazr.server.configuration.ConfigurationProperties;
import com.qwazr.utils.StringUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfiguration
implements ConfigurationProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConfiguration.class);
    private final Map<Object, Object> properties = new HashMap<Object, Object>();
    public final File dataDirectory;
    public final File tempDirectory;
    public final Set<File> etcDirectories;
    public final FileFilter etcFileFilter;
    public final String publicAddress;
    public final String listenAddress;
    public final WebConnector webAppConnector;
    public final WebConnector webServiceConnector;
    public final WebConnector multicastConnector;
    public final Set<String> masters;
    public final Set<String> groups;
    private static final String DEFAULT_LISTEN_ADDRESS = "0.0.0.0";
    private static final String DEFAULT_PUBLIC_ADDRESS = "localhost";

    public ServerConfiguration(String ... args) throws IOException {
        this(System.getenv(), System.getProperties(), ServerConfiguration.argsToMap(args));
    }

    protected ServerConfiguration(Map<?, ?> ... propertiesMaps) throws IOException {
        if (propertiesMaps != null) {
            for (Map<?, ?> props : propertiesMaps) {
                if (props == null) continue;
                props.forEach((key, value) -> this.properties.put(key.toString(), value));
            }
        }
        this.dataDirectory = ServerConfiguration.getDataDirectory(this.getStringProperty("QWAZR_DATA", null));
        if (this.dataDirectory == null) {
            throw new IOException("The data directory has not been set.");
        }
        if (!this.dataDirectory.exists()) {
            throw new IOException("The data directory does not exists: " + this.dataDirectory.getAbsolutePath());
        }
        if (!this.dataDirectory.isDirectory()) {
            throw new IOException("The data directory is not a directory: " + this.dataDirectory.getAbsolutePath());
        }
        this.tempDirectory = ServerConfiguration.getTempDirectory(this.dataDirectory, this.getStringProperty("QWAZR_TEMP", null));
        if (!this.tempDirectory.exists()) {
            this.tempDirectory.mkdirs();
        }
        if (!this.dataDirectory.exists()) {
            throw new IOException("The temp directory does not exists: " + this.tempDirectory.getAbsolutePath());
        }
        if (!this.dataDirectory.isDirectory()) {
            throw new IOException("The temp directory is not a directory: " + this.tempDirectory.getAbsolutePath());
        }
        this.etcDirectories = ServerConfiguration.getEtcDirectories(this.getStringProperty("QWAZR_ETC_DIR", null));
        this.etcFileFilter = ServerConfiguration.buildEtcFileFilter(this.getStringProperty("QWAZR_ETC", null));
        this.listenAddress = ServerConfiguration.findListenAddress(this.getStringProperty("LISTEN_ADDR", null));
        this.publicAddress = ServerConfiguration.findPublicAddress(this.getStringProperty("PUBLIC_ADDR", null), this.listenAddress);
        this.webAppConnector = new WebConnector(this.publicAddress, this.getIntegerProperty("WEBAPP_PORT", null), 9090, this.getStringProperty("WEBAPP_REALM", null));
        this.webServiceConnector = new WebConnector(this.publicAddress, this.getIntegerProperty("WEBSERVICE_PORT", null), 9091, this.getStringProperty("WEBSERVICE_REALM", null));
        this.multicastConnector = new WebConnector(this.getStringProperty("MULTICAST_ADDR", null), this.getIntegerProperty("MULTICAST_PORT", null), 9091, null);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        try {
            ServerConfiguration.findMatchingAddress(this.getStringProperty("QWAZR_MASTERS", null), set);
        }
        catch (SocketException e) {
            LOGGER.warn("Failed in extracting IP information. No master server is configured.");
        }
        this.masters = set.isEmpty() ? null : Collections.unmodifiableSet(set);
        this.groups = ServerConfiguration.buildSet(this.getStringProperty("QWAZR_GROUPS", null), ",; \t", true);
    }

    public Collection<File> getEtcFiles() {
        if (this.etcDirectories == null) {
            return null;
        }
        LinkedHashSet<File> etcFiles = new LinkedHashSet<File>();
        this.etcDirectories.forEach(dir -> {
            File[] files;
            File[] fileArray = files = this.etcFileFilter == null ? dir.listFiles() : dir.listFiles(this.etcFileFilter);
            if (files != null) {
                for (File file : files) {
                    etcFiles.add(file);
                }
            }
        });
        return etcFiles;
    }

    public String getStringProperty(String propName, String defaultValue) {
        Object o = this.properties.get(propName);
        return o == null ? defaultValue : o.toString();
    }

    public Integer getIntegerProperty(String propName, Integer defaultValue) {
        Object o = this.properties.get(propName);
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.parseInt(o.toString());
    }

    protected static void fillStringListProperty(String value, String separatorChars, boolean trim, Consumer<String> consumer) {
        String[] parts;
        if (value == null) {
            return;
        }
        for (String part : parts = StringUtils.split(value, separatorChars)) {
            if (part == null) continue;
            consumer.accept(trim ? part.trim() : part);
        }
    }

    protected static Set<String> buildSet(String value, String separatorChars, boolean trim) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        HashSet set = new HashSet();
        ServerConfiguration.fillStringListProperty(value, separatorChars, trim, set::add);
        return Collections.unmodifiableSet(set);
    }

    private static File getDataDirectory(String dataDir) {
        return StringUtils.isEmpty(dataDir) ? new File(System.getProperty("user.dir")) : new File(dataDir);
    }

    private static File getTempDirectory(File dataDir, String value) {
        return value == null || value.isEmpty() ? new File(dataDir, "tmp") : new File(value);
    }

    private static Set<File> getEtcDirectories(String value) {
        LinkedHashSet set = new LinkedHashSet();
        ServerConfiguration.fillStringListProperty(value == null ? "etc" : value, File.pathSeparator, true, part -> {
            File etcFile = new File((String)part);
            set.add(etcFile);
            LOGGER.info("Configuration (ETC) directory: " + etcFile.getAbsolutePath());
        });
        return Collections.unmodifiableSet(set);
    }

    private static FileFilter buildEtcFileFilter(String etcFilter) {
        if (StringUtils.isEmpty(etcFilter)) {
            return FileFileFilter.FILE;
        }
        String[] array = StringUtils.split(etcFilter, ',');
        if (array == null || array.length == 0) {
            return FileFileFilter.FILE;
        }
        return new AndFileFilter(FileFileFilter.FILE, new ConfigurationFileFilter(array));
    }

    private static void findMatchingAddress(String addressPattern, Collection<String> collect) throws SocketException {
        String[] patterns = StringUtils.split(addressPattern, ",; ");
        if (patterns == null) {
            return;
        }
        for (String pattern : patterns) {
            if (pattern == null) continue;
            if (!(pattern = pattern.trim()).contains("/")) {
                collect.add(pattern);
                continue;
            }
            SubnetUtils.SubnetInfo subnet = pattern.contains("/") ? new SubnetUtils(pattern).getInfo() : null;
            Enumeration<NetworkInterface> enumInterfaces = NetworkInterface.getNetworkInterfaces();
            while (enumInterfaces != null && enumInterfaces.hasMoreElements()) {
                NetworkInterface ifc = enumInterfaces.nextElement();
                if (!ifc.isUp()) continue;
                Enumeration<InetAddress> enumAddresses = ifc.getInetAddresses();
                while (enumAddresses != null && enumAddresses.hasMoreElements()) {
                    InetAddress inetAddress = enumAddresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    String address = inetAddress.getHostAddress();
                    if ((subnet == null || !subnet.isInRange(address)) && !address.equals(pattern)) continue;
                    collect.add(address);
                }
            }
        }
    }

    private static String findListenAddress(String addressPattern) {
        if (StringUtils.isEmpty(addressPattern)) {
            return DEFAULT_LISTEN_ADDRESS;
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            ServerConfiguration.findMatchingAddress(addressPattern, list);
            return list.isEmpty() ? DEFAULT_LISTEN_ADDRESS : list.get(0);
        }
        catch (SocketException e) {
            LOGGER.warn("Failed in extracting IP informations. Listen address set to default (0.0.0.0)", e);
            return DEFAULT_LISTEN_ADDRESS;
        }
    }

    private static String getLocalHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Cannot extract the address of the localhost.", e);
            return DEFAULT_PUBLIC_ADDRESS;
        }
    }

    private static String findPublicAddress(String addressPattern, String listenAddress) {
        if (StringUtils.isEmpty(addressPattern)) {
            return StringUtils.isEmpty(listenAddress) || DEFAULT_LISTEN_ADDRESS.equals(listenAddress) ? ServerConfiguration.getLocalHostAddress() : listenAddress;
        }
        try {
            ArrayList<String> list = new ArrayList<String>();
            ServerConfiguration.findMatchingAddress(addressPattern, list);
            return list.isEmpty() ? DEFAULT_PUBLIC_ADDRESS : list.get(0);
        }
        catch (SocketException e) {
            String addr = StringUtils.isEmpty(listenAddress) || DEFAULT_LISTEN_ADDRESS.equals(listenAddress) ? DEFAULT_PUBLIC_ADDRESS : listenAddress;
            LOGGER.warn("Failed in extracting IP informations. Public address set to default (" + addr + ")", e);
            return addr;
        }
    }

    private static Map<String, String> argsToMapPrefix(String prefix, String ... args) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (args == null || args.length == 0) {
            return props;
        }
        Integer prefixLength = prefix == null || prefix.isEmpty() ? null : Integer.valueOf(prefix.length());
        for (String arg : args) {
            String[] split;
            int l;
            if (arg == null || arg.isEmpty() || prefixLength != null && !arg.startsWith(prefix) || (l = (split = StringUtils.split(arg, "=")).length - 1) < 1) continue;
            String value = split[l];
            for (int i = 0; i < l; ++i) {
                String key = prefixLength == null || i > 0 ? split[i] : split[i].substring(prefixLength);
                props.put(key, value);
            }
        }
        return props;
    }

    protected static Map<String, String> argsToMap(String ... args) throws IOException {
        Map<String, String> props = ServerConfiguration.argsToMapPrefix("--", args);
        String propertyFile = props.get("QWAZR_PROPERTIES");
        if (propertyFile == null) {
            propertyFile = System.getProperty("QWAZR_PROPERTIES", System.getenv("QWAZR_PROPERTIES"));
        }
        if (propertyFile != null) {
            File propFile = new File(propertyFile);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Load QWAZR_PROPERTIES file: " + propFile.getAbsolutePath());
            }
            Properties properties = new Properties();
            try (FileReader reader = new FileReader(propFile);){
                properties.load(reader);
            }
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> props.putIfAbsent(key.toString(), value.toString())));
        }
        return props;
    }

    public static Builder of() {
        return ServerConfiguration.of(null);
    }

    public static Builder of(Map<String, String> map) {
        return new Builder(map);
    }

    public static class Builder {
        protected final Map<String, String> map;
        private final Set<String> masters;
        private final Set<String> groups;
        private final Set<String> etcFilters;
        private final Set<String> etcDirectories;

        protected Builder(Map<String, String> map) {
            this.map = map == null ? new HashMap<String, String>() : new HashMap<String, String>(map);
            this.masters = new LinkedHashSet<String>();
            this.groups = new LinkedHashSet<String>();
            this.etcFilters = new LinkedHashSet<String>();
            this.etcDirectories = new LinkedHashSet<String>();
        }

        public Builder data(File file) {
            if (file != null) {
                this.map.put("QWAZR_DATA", file.getPath());
            }
            return this;
        }

        public Builder temp(File file) {
            if (file != null) {
                this.map.put("QWAZR_TEMP", file.getPath());
            }
            return this;
        }

        public Builder publicAddress(String address) {
            if (address != null) {
                this.map.put("PUBLIC_ADDR", address);
            }
            return this;
        }

        public Builder listenAddress(String address) {
            if (address != null) {
                this.map.put("LISTEN_ADDR", address);
            }
            return this;
        }

        public Builder master(String master) {
            if (master != null) {
                this.masters.add(master);
            }
            return this;
        }

        public Builder group(String group) {
            if (group != null) {
                this.groups.add(group);
            }
            return this;
        }

        public Builder etcFilter(String etcFilter) {
            if (etcFilter != null) {
                this.etcFilters.add(etcFilter);
            }
            return this;
        }

        public Builder etcDirectory(File etcDirectory) {
            if (etcDirectory != null) {
                this.etcDirectories.add(etcDirectory.getAbsolutePath());
            }
            return this;
        }

        public Builder webAppPort(Integer webappPort) {
            if (webappPort != null) {
                this.map.put("WEBAPP_PORT", webappPort.toString());
            }
            return this;
        }

        public Builder webServicePort(Integer webServicePort) {
            if (webServicePort != null) {
                this.map.put("WEBSERVICE_PORT", webServicePort.toString());
            }
            return this;
        }

        public Builder webAppRealm(String webAppRealm) {
            if (webAppRealm != null) {
                this.map.put("WEBAPP_REALM", webAppRealm);
            }
            return this;
        }

        public Builder webServiceRealm(String webServiceRealm) {
            if (webServiceRealm != null) {
                this.map.put("WEBSERVICE_REALM", webServiceRealm);
            }
            return this;
        }

        public Builder multicastAddress(String multicastAddress) {
            if (multicastAddress != null) {
                this.map.put("MULTICAST_ADDR", multicastAddress);
            }
            return this;
        }

        public Builder multicastPort(Integer multicastPort) {
            if (multicastPort != null) {
                this.map.put("MULTICAST_PORT", multicastPort.toString());
            }
            return this;
        }

        public Map<String, String> finalMap() {
            if (!this.masters.isEmpty()) {
                this.map.put("QWAZR_MASTERS", StringUtils.join(this.masters, ','));
            }
            if (!this.groups.isEmpty()) {
                this.map.put("QWAZR_GROUPS", StringUtils.join(this.groups, ','));
            }
            if (!this.etcFilters.isEmpty()) {
                this.map.put("QWAZR_ETC", StringUtils.join(this.etcFilters, ','));
            }
            if (!this.etcDirectories.isEmpty()) {
                this.map.put("QWAZR_ETC_DIR", StringUtils.join(this.etcDirectories, File.pathSeparatorChar));
            }
            return this.map;
        }

        public ServerConfiguration build() throws IOException {
            return new ServerConfiguration(this.finalMap());
        }
    }

    public static class WebConnector {
        public final String address;
        public final String realm;
        public final int port;
        public final String addressPort;

        private WebConnector(String address, Integer port, int defaulPort, String realm) {
            this.address = address;
            this.realm = realm;
            this.port = port == null ? defaulPort : port;
            this.addressPort = this.address == null ? null : this.address + ":" + this.port;
        }
    }
}

