/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server.response;

import com.qwazr.server.response.ResponseValidator;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;

public abstract class AbstractHttpResponseHandler<T>
implements ResponseHandler<T> {
    private final ResponseValidator validator;
    protected Header[] headers;
    protected HttpEntity entity;
    protected StatusLine statusLine;

    public AbstractHttpResponseHandler(ResponseValidator validator) {
        this.validator = validator;
    }

    @Override
    public T handleResponse(HttpResponse response) throws IOException {
        if (response == null) {
            throw new ClientProtocolException("No response");
        }
        this.headers = response.getAllHeaders();
        this.entity = response.getEntity();
        this.statusLine = response.getStatusLine();
        if (this.validator != null) {
            this.validator.check(this.headers, this.statusLine, this.entity);
        }
        return null;
    }
}

