/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.qwazr.utils.ExceptionUtils;
import com.qwazr.utils.json.JsonMapper;
import java.util.List;
import javax.ws.rs.core.Response;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class JsonExceptionReponse {
    public final String error;
    public final String reason_phrase;
    public final Integer status_code;
    public final String message;
    public final String exception;
    public final List<String> stackTraces;

    public JsonExceptionReponse(Response.Status status, String message) {
        this.error = status == null ? null : status.name();
        this.reason_phrase = status == null ? null : status.getReasonPhrase();
        this.status_code = status == null ? null : Integer.valueOf(status.getStatusCode());
        this.message = message;
        this.exception = null;
        this.stackTraces = null;
    }

    public JsonExceptionReponse(Response.Status status, Throwable e) {
        this.error = status == null ? null : status.name();
        this.reason_phrase = status == null ? null : status.getReasonPhrase();
        this.status_code = status == null ? null : Integer.valueOf(status.getStatusCode());
        Throwable cause = e == null ? null : ExceptionUtils.getRootCause(e);
        this.message = cause == null ? null : cause.getMessage();
        this.exception = cause == null ? null : cause.getClass().getName();
        this.stackTraces = cause == null ? null : ExceptionUtils.getStackTraces(cause);
    }

    public JsonExceptionReponse(Response.Status status, String error, Throwable e) {
        this.error = error;
        this.reason_phrase = status == null ? null : status.getReasonPhrase();
        this.status_code = status == null ? null : Integer.valueOf(status.getStatusCode());
        Throwable cause = e == null ? null : ExceptionUtils.getRootCause(e);
        this.message = cause == null ? null : cause.getMessage();
        this.exception = cause == null ? null : cause.getClass().getName();
        this.stackTraces = cause == null ? null : ExceptionUtils.getStackTraces(cause);
    }

    public JsonExceptionReponse(int status, String message, Throwable e) {
        Throwable cause;
        this.error = null;
        this.reason_phrase = null;
        this.status_code = status;
        Throwable throwable = cause = e == null ? null : ExceptionUtils.getRootCause(e);
        this.message = message == null ? (cause == null ? null : cause.getMessage()) : message;
        this.exception = cause == null ? null : cause.getClass().getName();
        this.stackTraces = cause == null ? null : ExceptionUtils.getStackTraces(cause);
    }

    public Response toResponse() {
        try {
            String jsonMessage = JsonMapper.MAPPER.writeValueAsString(this);
            return Response.status(this.status_code).type("application/json; charset=UTF-8").entity(jsonMessage).build();
        }
        catch (JsonProcessingException e) {
            return Response.status(this.status_code).type("text/plain").entity(this.message).build();
        }
    }
}

