/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server.response;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.qwazr.server.response.AbstractHttpResponseHandler;
import com.qwazr.server.response.ResponseValidator;
import com.qwazr.utils.IOUtils;
import com.qwazr.utils.json.JsonMapper;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;

public class JsonHttpResponseHandler {

    public static class JsonValueTypeRefResponse<T>
    extends AbstractHttpResponseHandler<T> {
        private final TypeReference<T> typeReference;

        public JsonValueTypeRefResponse(TypeReference<T> typeReference, ResponseValidator validator) {
            super(validator);
            this.typeReference = typeReference;
        }

        @Override
        public final T handleResponse(HttpResponse response) throws IOException {
            try {
                super.handleResponse(response);
                T t = this.entity == null ? null : (T)JsonMapper.MAPPER.readValue(this.entity.getContent(), this.typeReference);
                return t;
            }
            finally {
                IOUtils.close((AutoCloseable)((CloseableHttpResponse)response));
            }
        }
    }

    public static class JsonValueResponse<T>
    extends AbstractHttpResponseHandler<T> {
        private final Class<T> jsonClass;

        public JsonValueResponse(Class<T> jsonClass, ResponseValidator validator) {
            super(validator);
            this.jsonClass = jsonClass;
        }

        @Override
        public final T handleResponse(HttpResponse response) throws IOException {
            try {
                super.handleResponse(response);
                T t = this.entity == null ? null : (T)JsonMapper.MAPPER.readValue(this.entity.getContent(), this.jsonClass);
                return t;
            }
            finally {
                IOUtils.close((AutoCloseable)((CloseableHttpResponse)response));
            }
        }
    }

    public static class JsonTreeResponse
    extends AbstractHttpResponseHandler<JsonNode> {
        public JsonTreeResponse(ResponseValidator validator) {
            super(validator);
        }

        @Override
        public final JsonNode handleResponse(HttpResponse response) throws IOException {
            try {
                super.handleResponse(response);
                JsonNode jsonNode = this.entity == null ? null : JsonMapper.MAPPER.readTree(this.entity.getContent());
                return jsonNode;
            }
            finally {
                IOUtils.close((AutoCloseable)((CloseableHttpResponse)response));
            }
        }
    }
}

