/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.server.response;

import com.qwazr.utils.StringUtils;
import com.qwazr.utils.http.HttpResponseEntityException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.entity.ContentType;

public class ResponseValidator {
    protected final ResponseValidator parent;

    public ResponseValidator() {
        this.parent = null;
    }

    public static ResponseValidator create() {
        return new ResponseValidator();
    }

    protected ResponseValidator(ResponseValidator parent) {
        this.parent = parent;
    }

    public ResponseValidator status(int ... expectedCodes) {
        if (expectedCodes == null) {
            return this;
        }
        return new Status(this, expectedCodes);
    }

    public ResponseValidator content(ContentType contentType) {
        if (contentType == null) {
            return null;
        }
        return new Content(this, contentType);
    }

    public final void checkResponse(Header[] headers, StatusLine statusLine, HttpEntity entity) throws ClientProtocolException {
        this.check(headers, statusLine, entity);
    }

    protected void check(Header[] headers, StatusLine statusLine, HttpEntity entity) throws ClientProtocolException {
        if (this.parent != null) {
            this.parent.check(headers, statusLine, entity);
        }
    }

    private class Content
    extends ResponseValidator {
        private final ContentType expectedContentType;

        private Content(ResponseValidator parent, ContentType expectedContentType) {
            super(parent);
            this.expectedContentType = expectedContentType;
        }

        @Override
        protected final void check(Header[] headers, StatusLine statusLine, HttpEntity entity) throws ClientProtocolException {
            super.check(headers, statusLine, entity);
            if (entity == null || this.expectedContentType == null) {
                return;
            }
            ContentType contentType = ContentType.get(entity);
            if (contentType == null) {
                throw new HttpResponseEntityException(statusLine, entity, "Unknown content type");
            }
            if (!this.expectedContentType.getMimeType().equals(contentType.getMimeType())) {
                throw new HttpResponseEntityException(statusLine, entity, StringUtils.fastConcat("Wrong content type: ", contentType.getMimeType()));
            }
        }
    }

    private class Status
    extends ResponseValidator {
        private final int[] expectedCodes;

        private Status(ResponseValidator parent, int ... expectedCodes) {
            super(parent);
            this.expectedCodes = expectedCodes;
        }

        @Override
        protected final void check(Header[] headers, StatusLine statusLine, HttpEntity entity) throws ClientProtocolException {
            super.check(headers, statusLine, entity);
            if (statusLine == null) {
                throw new ClientProtocolException("Response does not contains any status");
            }
            if (this.expectedCodes == null) {
                return;
            }
            int statusCode = statusLine.getStatusCode();
            for (int code : this.expectedCodes) {
                if (code != statusCode) continue;
                return;
            }
            throw new HttpResponseEntityException(statusLine, entity, StringUtils.fastConcat("Unexpected HTTP status code: ", statusCode));
        }
    }
}

