/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.qwazr.utils.LockUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public class AccessTimeCacheMap<K, V> {
    private volatile int size;
    private final EldestMap entryMap;
    private final LockUtils.ReadWriteLock rwl = new LockUtils.ReadWriteLock();
    private final long msTimeOut;

    public AccessTimeCacheMap(int secondsTimeOut) {
        this.entryMap = new EldestMap();
        this.msTimeOut = secondsTimeOut * 1000;
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getSynchronizedValue(K key, long nextExpirationTime) {
        AccessTimeCacheEntry entry = (AccessTimeCacheEntry)this.entryMap.get(key);
        if (entry == null) {
            return null;
        }
        AccessTimeCacheEntry accessTimeCacheEntry = entry;
        synchronized (accessTimeCacheEntry) {
            return (V)entry.getValue(nextExpirationTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrCreate(K key, Supplier<V> supplier) {
        AccessTimeCacheEntry entry;
        long nextExpirationTime = System.currentTimeMillis() + this.msTimeOut;
        Object val = this.rwl.read(() -> this.getSynchronizedValue(key, nextExpirationTime));
        if (val != null) {
            return (V)val;
        }
        AccessTimeCacheEntry accessTimeCacheEntry = entry = new AccessTimeCacheEntry(nextExpirationTime);
        synchronized (accessTimeCacheEntry) {
            return (V)this.rwl.write(() -> {
                V value = this.getSynchronizedValue(key, nextExpirationTime);
                if (value != null) {
                    return value;
                }
                this.entryMap.put(key, entry);
                this.size = this.entryMap.size();
                entry.setValue(supplier);
                return entry.value;
            });
        }
    }

    public V remove(K key) {
        Object val = this.rwl.read(() -> this.getSynchronizedValue(key, 0L));
        if (val == null) {
            return null;
        }
        return (V)this.rwl.write(() -> {
            V value = this.getSynchronizedValue(key, 0L);
            if (value == null) {
                return null;
            }
            this.entryMap.remove(key);
            this.size = this.entryMap.size();
            return value;
        });
    }

    public int size() {
        return this.size;
    }

    private class AccessTimeCacheEntry<T> {
        private volatile long expirationTime;
        private T value;

        AccessTimeCacheEntry(long newExpirationTime) {
            this.expirationTime = newExpirationTime;
            this.value = null;
        }

        void setValue(Supplier<T> supplier) {
            this.value = supplier.get();
        }

        T getValue(long newExpirationTime) {
            this.expirationTime = newExpirationTime;
            return this.value;
        }

        boolean isExpired(long compareTime) {
            return this.expirationTime < compareTime;
        }
    }

    private class EldestMap
    extends LinkedHashMap<K, AccessTimeCacheEntry<V>> {
        private EldestMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, AccessTimeCacheEntry<V>> eldest) {
            return eldest.getValue().isExpired(System.currentTimeMillis());
        }
    }
}

