/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class AnnotationsUtils {
    public static <A extends Annotation> A getFirstAnnotation(Class<?> clazz, Class<A> annotationClass, Set<Class<?>> checked) {
        if (clazz == null) {
            return null;
        }
        if (checked.contains(clazz)) {
            return null;
        }
        checked.add(clazz);
        A annotation = clazz.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        annotation = AnnotationsUtils.getFirstAnnotation(clazz.getInterfaces(), annotationClass, checked);
        if (annotation != null) {
            return annotation;
        }
        return AnnotationsUtils.getFirstAnnotation(clazz.getSuperclass(), annotationClass, checked);
    }

    public static <A extends Annotation> A getFirstAnnotation(Class<?> clazz, Class<A> annotationClass) {
        return AnnotationsUtils.getFirstAnnotation(clazz, annotationClass, new HashSet());
    }

    public static <A extends Annotation> A getFirstAnnotation(Class<?>[] classes, Class<A> annotationClass, Set<Class<?>> checked) {
        if (classes == null) {
            return null;
        }
        for (Class<?> cl : classes) {
            A annotation = AnnotationsUtils.getFirstAnnotation(cl, annotationClass, checked);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static void browseFieldsRecursive(Class<?> clazz, Consumer<Field> consumer) {
        if (clazz == null || clazz.isPrimitive()) {
            return;
        }
        AnnotationsUtils.browseFields(clazz.getDeclaredFields(), consumer);
        Class<?> nextClazz = clazz.getSuperclass();
        if (nextClazz == clazz) {
            return;
        }
        AnnotationsUtils.browseFieldsRecursive(nextClazz, consumer);
    }

    public static void browseFields(Field[] fields, Consumer<Field> consumer) {
        if (fields == null || consumer == null) {
            return;
        }
        for (Field field : fields) {
            consumer.accept(field);
        }
    }
}

