/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class CharsetUtils {
    public static final Charset CharsetUTF8 = Charset.forName("UTF-8");

    public static final String charsetDetector(InputStream inputStream) throws IOException {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(inputStream);
        CharsetMatch match = detector.detect();
        return match == null ? null : match.getName();
    }

    public static final String charsetDetector(byte[] bytes) {
        CharsetDetector detector = new CharsetDetector();
        detector.setText(bytes);
        CharsetMatch match = detector.detect();
        return match == null ? null : match.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CharsetEncoder newUTF8Encoder() {
        Charset charset = CharsetUTF8;
        synchronized (charset) {
            return CharsetUTF8.newEncoder();
        }
    }

    public static final byte[] encodeUtf8(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(CharsetUTF8);
    }

    public static final String decodeUtf8(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, CharsetUTF8);
    }

    public static final String decodeUtf8(ByteBuffer bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return new String(CharsetUTF8.newDecoder().decode(bytes).array());
    }
}

