/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.utils;

import java.io.IOException;
import java.io.InputStream;

public class ClassLoaderUtils {
    private static volatile ClassFactory currentClassFactory = DefaultFactory.INSTANCE;

    public static final <T> Class<T> findClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if (classLoader != null) {
            return classLoader.loadClass(className);
        }
        return Class.forName(className);
    }

    public static final InputStream getResourceAsStream(ClassLoader classLoader, String name) {
        if (classLoader != null) {
            return classLoader.getResourceAsStream(name);
        }
        return ClassLoaderUtils.class.getResourceAsStream(name);
    }

    public static final <T> Class<T> findClass(ClassLoader classLoader, String[] classPrefixes, String suffix) throws ClassNotFoundException {
        ClassNotFoundException firstClassException = null;
        for (String prefix : classPrefixes) {
            try {
                return ClassLoaderUtils.findClass(classLoader, prefix + suffix);
            }
            catch (ClassNotFoundException e) {
                if (firstClassException != null) continue;
                firstClassException = e;
            }
        }
        throw firstClassException;
    }

    public static final <T> Class<T> findClass(ClassLoader classLoader, String classDef, String[] classPrefixes) throws ReflectiveOperationException, IOException {
        if (classDef == null) {
            return null;
        }
        if (classPrefixes == null) {
            return ClassLoaderUtils.findClass(classLoader, classDef);
        }
        return ClassLoaderUtils.findClass(classLoader, classPrefixes, classDef);
    }

    public static final void register(ClassFactory classFactory) {
        currentClassFactory = classFactory == null ? DefaultFactory.INSTANCE : classFactory;
    }

    public static final <T> T newInstance(Class<T> clazz) throws ReflectiveOperationException {
        return currentClassFactory.newInstance(clazz);
    }

    static class DefaultFactory
    implements ClassFactory {
        static final DefaultFactory INSTANCE = new DefaultFactory();

        DefaultFactory() {
        }

        @Override
        public final <T> T newInstance(Class<T> clazz) throws ReflectiveOperationException {
            return clazz.newInstance();
        }
    }

    static interface ClassFactory {
        public <T> T newInstance(Class<T> var1) throws ReflectiveOperationException;
    }
}

